/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.logic.validation.EditCollectionIF;
import gov.cms.hh.logic.validation.EditIF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author CMS
 * @param <T>
 */
public class ClaimElementCollection<T> implements ClaimElementCollectionIF<T>, Serializable {
    
    private final ClaimElementBase claimElement;

    private final List<T> collection;
    
    /**
     * Constructor
     */
    public ClaimElementCollection() {
        this.collection = new ArrayList<>();
        this.claimElement = new ClaimElementBase();
    }

    /**
     *
     * @param edits
     */
    @Override
    public void addEdits(List<EditIF> edits) {
        claimElement.addEdits(edits);
    }

    /**
     *
     * @return
     */
    @Override
    public EditCollectionIF getEditCollection() {
        return claimElement.getEditCollection();
    }

    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        claimElement.addEdit(edit);
    }

    /**
     * @return the collection
     */
    @Override
    public List<T> getCollection() {
        return collection;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isValid() {
        return claimElement.isValid();
    }

    /**
     *
     * @param valid
     */
    @Override
    public void setValid(boolean valid) {
        claimElement.setValid(valid);
    }
}
