/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.reference.objects.HippsValueObject;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author CMS
 */
public class HippsCode extends ClaimElementBase implements HippsCodeIF {

    private static final long serialVersionUID = 1L;
    
    final String HIPPS_INIT_CHAR = "0";
    final int HIIPS_DIGITS_TO_CHECK = 4;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "HippsCode{" + "hipps=" + hipps + '}';
    }

    /**
     * Constructor
     */
    public HippsCode() {
        hipps = new TreeMap();
        // construct empty HIPPS code
        // with init values of "0"
        for (int i = 1; i <= 5; i++) {
            HippsValueObject filler = new HippsValueObject();
            filler.setPosition("" + i);
            filler.setPositionDescription("Position " + i);
            filler.setValue(HIPPS_INIT_CHAR);
            filler.setValueDescription("Init value");
            hipps.put(i, filler);
        }
    }

    private Map<Integer, HippsValueObject> hipps;

    /**
     * @return the hipps
     */
    @Override
    public Map<Integer, HippsValueObject> getHipps() {
        return hipps;
    }

    /**
     * @param hipps the hipps to set
     */
    @Override
    public void setHipps(Map<Integer, HippsValueObject> hipps) {
        this.hipps = hipps;
    }

    /**
     *
     * @param value
     * @return
     */
    @Override
    public boolean setValue(HippsValueObject value) {
        int position = Integer.parseInt(value.getPosition());
        if (position < 1 || position > 5) {
            return false;
        }
        hipps.put(position, value);
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public String getHippsCode() {
        StringBuilder ret = new StringBuilder();
        hipps.values().forEach((value) -> {
            ret.append(value.getValue());
        });
        return ret.toString();
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getHippsCharacter(int position) {
        return getValue(position).getValue();
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public HippsValueObject getValue(int position) {
        if (position < 1 || position > 5) {
            return null;
        }
        if (hipps != null) {
            return hipps.get(position);
        } else {
            return null;
        }
    }

    /**
     *
     * @return
     */
    @Override
    public boolean isHippsComplete() {
        for (int i = 1; i <= HIIPS_DIGITS_TO_CHECK; i++) {
            if(getHippsCharacter(i).equals(HIPPS_INIT_CHAR)) {
                return false;
            }
        }
        return true;
    }

    /**
     *
     * @return
     */
    @Override
    public String getFinalHippsCode() {
        if(isHippsComplete()) {
            return getHippsCode();
        } else {
            return "00000";
        }
    }
}
