/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.reference.objects.DiagnosisSubchapterObject;

/**
 *
 * @author CMS
 */
public class DiagnosisSubchapter implements DiagnosisSubchapterIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "DiagnosisSubchapter{" + "id=" + id + ", dxFrom=" + dxFrom + ", dxTo=" + dxTo + ", description=" + description + '}';
    }
    
    /**
     *
     * @param dxSubchapterObject
     */
    public DiagnosisSubchapter(DiagnosisSubchapterObject dxSubchapterObject) {
        this.id = Integer.parseInt(dxSubchapterObject.getId());
        this.dxFrom = dxSubchapterObject.getDiagnosisFrom();
        this.dxTo = dxSubchapterObject.getDiagnosisTo();
        this.description = dxSubchapterObject.getDescription();
    }
    
    /**
     *
     * @param id
     * @param dxFrom
     * @param dxTo
     * @param description
     */
    public DiagnosisSubchapter(int id, String dxFrom, String dxTo, String description) {
        this.id = id;
        this.dxFrom = dxFrom;
        this.dxTo = dxTo;
        this.description = description;
    }

    /**
     * @return the dxFrom
     */
    @Override
    public String getDxFrom() {
        return dxFrom;
    }

    /**
     * @param dxFrom the dxFrom to set
     */
    @Override
    public void setDxFrom(String dxFrom) {
        this.dxFrom = dxFrom;
    }

    /**
     * @return the dxTo
     */
    @Override
    public String getDxTo() {
        return dxTo;
    }

    /**
     * @param dxTo the dxTo to set
     */
    @Override
    public void setDxTo(String dxTo) {
        this.dxTo = dxTo;
    }
    private int id;
    private String dxFrom;
    private String dxTo;
    private String description;

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}
