/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.grouper.DataManagerIF;

/**
 *
 * @author CMS
 */
public class HippsPosition5 extends HippsPositionAbstract implements HippsPositionIF {

    /*
    * 5. HIPPS 5th position
     */

    /**
     *
     * @param claim
     * @param dataManager
     */

    public HippsPosition5(final ClaimIF claim, final DataManagerIF dataManager) {
        super(claim, dataManager);
        setOrder(5);
    }

    /**
     *
     * @return
     */
    @Override
    public boolean validate() {
        return getClaim().getHippsCode().isHippsComplete();
    }

    /**
     *
     * @return
     */
    @Override
    public boolean calculate() {

        final int HIPPS_POSITION = 5;
        
        final int GRC_OK = 0;

        // add "0" GRC if success
        if(getClaim().getHippsCode().isHippsComplete()) {
            addReturnCode(GRC_OK);
        }

        addHippsLogicMessage(EditId_EN.VALUE_HIPPS5, "HIPPS Position 5 = 1 (filler)");
        
        // Set HIPPS 5
        return setHippsCode(HIPPS_POSITION, "" + 1);
        
    }

}
