/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.meta.MetaData;
import gov.cms.hh.logic.specification.abstr.*;
import gov.cms.hh.grouper.utility.Utility;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

/**
 *
 * @author CMS
 */
public class IsValidThroughDate extends AbstractSpecification<String> {

    /**
     * @return the throughDate
     */
    public Date getThroughDate() {
        return throughDate;
    }

    /**
     * @return the exceeded
     */
    public boolean isExceeded() {
        return exceeded;
    }

    /**
     * @return the preceded
     */
    public boolean isPreceded() {
        return preceded;
    }

    private Date fromDate = null;
    private Date throughDate = null;
    private boolean exceeded = false;
    private boolean preceded = false;
    private boolean shorter = false;
    private long days;

    /**
     *
     * @param fromDate
     */
    public IsValidThroughDate(String fromDate) {
        this.fromDate = processDate(fromDate);
    }

    private Date processDate(String date) {
        return Utility.processDate(date);
    }

    /**
     *
     * @param throughDate
     * @return
     */
    @Override
    public boolean isSatisfiedBy(String throughDate) {
        this.throughDate = processDate(throughDate);
        return isDaysInRange(throughDate);
    }

    public Date getFromDate() {
        return fromDate;
    }

    /**
     *
     * @param date
     * @return
     */
    protected boolean isDaysInRange(String date) {
        if (getFromDate() == null || getThroughDate() == null) {
            return false;
        }
        // Convert to Local Date as more safe for day range calculation 
        LocalDate startDate = getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = getThroughDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // Calculate span in days 
        days = ChronoUnit.DAYS.between(startDate, endDate);
        exceeded = days > MetaData.SPAN_CLAIM_RANGE_IN_DAYS;
        preceded = days < 0;
        shorter = days >= 0 && days < MetaData.SPAN_CLAIM_RANGE_IN_DAYS;
        return !(exceeded || preceded);
    }

    /**
     * @return the shorter
     */
    public boolean isShorter() {
        return shorter;
    }

    /**
     * @return the period of care in days
     */
    public long getPoc() {
        return days + 1;
    }
    
}
