
package gov.cms.hh.logic.specification.condition;

import gov.cms.hh.logic.specification.abstr.AndSpecification;
import gov.cms.hh.logic.specification.abstr.OrSpecification;
import gov.cms.hh.logic.specification.abstr.Specification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author CMS
 */
public class ConditionSpecificationBuilder {

    final String DELIMITER_OR = ";";
    final String DELIMITER_AND = "&";

    /**
     *
     * @param conditions
     * @return
     */
    public Specification<String> buildConditionSpecifications(String conditions){
        Specification<String> retSpec = parseConditions((conditions == null? "" : conditions));
        return retSpec;
    } 

    /**
     *
     * @param conditions
     * @return
     */
    protected Specification<String> parseConditions(String conditions) {
        // Build "or" specifications (main separator)
        OrSpecification<String> retSpec = null;
        List<String> condList = Arrays.asList(conditions.split(DELIMITER_OR));
        // 1. Build list of "or" specs
        List<Specification<String>> condSpecList = new ArrayList<>();
        for (String cond : condList) {
            if(cond.contains(DELIMITER_AND)) {
                condSpecList.add(buildMultiAndSpec(cond));
            } else {
                condSpecList.add(buildSingleSpec(cond));
            }
        }
        // 2. Merge "or" specs
        if(!condSpecList.isEmpty()) {
            for (Specification<String> specification : condSpecList) {
                if(retSpec == null) {
                    retSpec = new OrSpecification<>(specification,
                                    specification); // fake dups to create object
                } else {
                    retSpec.or(specification);
                }
            }
        }
        return retSpec;
    }
    
    /**
     *
     * @param specItem
     * @return
     */
    protected Specification<String> buildSingleSpec(String specItem) {
        Specification<String> retSpec = null;
        if(specItem.startsWith("<")) {
            String[] minMax = specItem.replaceAll("<", "").replaceAll(">", "").split("-");
            retSpec = new RangeCondition(minMax[0], minMax[1]);
        } else {
            retSpec = new RegexCondition(specItem);
        }
        return retSpec;
    }
    
    /**
     *
     * @param specItem
     * @return
     */
    protected Specification<String> buildMultiAndSpec(String specItem) {
        AndSpecification<String> retSpec = null;
        List<String> andCondList = Arrays.asList(specItem.split(DELIMITER_AND));
        // 1. Build list of "and" specs
        List<Specification<String>> condSpecList = new ArrayList<>();
        for (String cond : andCondList) {
            condSpecList.add(buildSingleSpec(cond));
        }
        // 2. Merge "and" specs
        if(!condSpecList.isEmpty()) {
            for (Specification<String> specification : condSpecList) {
                if(retSpec == null) {
                    retSpec = new AndSpecification<>(specification,
                                    specification); // fake dups to create object
                } else {
                    retSpec.and(specification);
                }
            }
        }
        return retSpec;
    }

}
