/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.validation;

import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import java.util.logging.Level;

/**
 *
 * @author CMS
 */
public class Edit implements EditIF {

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Edit{" + "id=" + id.name() + ", description=" + description + ", type=" + type + ", severityLevel=" + severityLevel + '}';
    }

    /**
     * @return the id
     */
    @Override
    public EditId_EN getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(EditId_EN id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the type
     */
    @Override
    public EditType_EN getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    @Override
    public void setType(EditType_EN type) {
        this.type = type;
    }

    /**
     * @return the severityLevel
     */
    @Override
    public Level getServerityLevel() {
        return severityLevel;
    }

    /**
     * @param serverityLevel the severityLevel to set
     */
    @Override
    public void setServerityLevel(Level serverityLevel) {
        this.severityLevel = serverityLevel;
    }

    /**
     *
     * @param id
     * @param description
     * @param type
     * @param serverityLevel
     */
    public Edit(EditId_EN id, String description, EditType_EN type, Level serverityLevel) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.severityLevel = serverityLevel;
    }


    private EditId_EN id;
    private String description;
    private EditType_EN type;
    private Level severityLevel;

}
