/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.validation;

import gov.cms.hh.data.meta.enumer.EditId_EN;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/**
 *
 * @author CMS
 */
public class EditCollection implements EditCollectionIF {

    /**
     * ctor
     */
    public EditCollection() {
        edits = new ArrayList<>();
    }

    private final List<EditIF> edits;

    /**
     *
     * @return
     */
    @Override
    public List<EditIF> getCriticalEdits() {
        List<EditIF> retList = new ArrayList<>();
        for (EditIF edit : edits) {
            if (edit.getServerityLevel() == Level.SEVERE) {
                retList.add(edit);
            }
        }
        return retList;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean hasCriticalEdits() {
        for (EditIF edit : edits) {
            if (edit.getServerityLevel() == Level.SEVERE) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @param editId
     * @return
     */
    @Override
    public List<EditIF> getEditId(EditId_EN editId) {
        List<EditIF> retList = new ArrayList<>();
        for (EditIF edit : edits) {
            if (edit.getId() == editId) {
                retList.add(edit);
            }
        }
        return retList;
    }

    /**
     *
     * @param editId
     * @return
     */
    @Override
    public boolean hasEditId(EditId_EN editId) {
        for (EditIF edit : edits) {
            if (edit.getId() == editId) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        edits.add(edit);
    }

    /**
     *
     * @return
     */
    @Override
    public List<EditIF> getEdits() {
        return edits;
    }

    /**
     *
     * @param editList
     */
    @Override
    public void addEdits(List<EditIF> editList) {
        edits.addAll(editList);
    }

    /**
     * @param edits the edits to set
     */
    public void setEdits(List<EditIF> edits) {
        this.edits.clear();
        this.edits.addAll(edits);
    }

}
