
package gov.cms.hh.v04223;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPosition1;
import gov.cms.hh.logic.specification.IsValidThroughDate;

/**
 *
 * @author US340646
 */
public class HippsPosition1_v04223 extends HippsPosition1 {
    
    public HippsPosition1_v04223(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }
    
    @Override
    public boolean validate() {
        final int GRC_INVALID_THROUGH_DATE = 1;
        // still validate the previous versions stuff
        boolean retPrev = super.validate();
        // check ThroughDate - v04.2.23 - Oct'23
        boolean retAdd = checkThroughDate(getClaim());
        if(!retAdd) {
            // generate GRC "INVALID THROUGH DATE"
            addReturnCode(GRC_INVALID_THROUGH_DATE);
        }
        return (retPrev && retAdd);
    }
    
    protected boolean checkThroughDate(ClaimIF claim) {
        int EMPTY = 11;
        int INVALID = 12;
        int PRECEDES = 13;
        int EXCEEDS = 14;
        int SHORTER = 15;
        String pocTemplate = "Period of care is: %s days";
        
        IsValidThroughDate dateChecker = new IsValidThroughDate(claim.getDateFrom().getValue());
        boolean retFlag = dateChecker.isSatisfiedBy(claim.getDateThrough().getValue());
        // 1. Empty ClaimThrough case
        if (claim.getDateThrough().getValue() == null ||
                claim.getDateThrough().getValue().trim().isEmpty()) {
            addValidityFlag(EMPTY);
        } else {
            if (dateChecker.getThroughDate() == null) {
                addValidityFlag(INVALID);
            } else {
                if(dateChecker.isExceeded()) {
                    addValidityFlag(EXCEEDS);
                    // Add logic info edits for Detail Report
                    // Exceeding period of care error
                    addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, 
                            String.format(pocTemplate, dateChecker.getPoc()));

                }
                if(dateChecker.isPreceded()) {
                    addValidityFlag(PRECEDES);
                }
                if(dateChecker.isShorter()) {
                    addValidityFlag(SHORTER);
                    // Add logic info edits for Detail Report
                    // Short period of care warning
                    addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, 
                            String.format(pocTemplate, dateChecker.getPoc()));
                }
            }
        }
        return retFlag;
    }
    
}
