/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.ClinicalGroupIF;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPositionAbstract;
import gov.cms.hh.logic.processor.HippsPositionIF;
import gov.cms.hh.logic.validation.Edit;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HippsPosition2
extends HippsPositionAbstract
implements HippsPositionIF {
    private static final Logger LOG = Logger.getLogger(HippsPosition2.class.getName());

    public HippsPosition2(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
        this.setOrder(2);
    }

    @Override
    public boolean validate() {
        this.validateDiagnoses();
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        if (this.checkAsPdx("PDX", pdx)) {
            DiagnosisIF sdx;
            List<DiagnosisIF> sdxList = this.getClaim().getSecondaryDiagnoses().getCollection();
            if (!sdxList.isEmpty() && (sdx = sdxList.get(0)).isPrimaryAwarding() && this.checkAsPdx("SDX1 as PDX", sdx)) {
                pdx.setValue(sdx.getValue());
                pdx.setPrimaryAwarding(sdx.isPrimaryAwarding());
                pdx.setManifestation(sdx.isManifestation());
                pdx.setId(sdx.getId());
                pdx.setECOI(sdx.isECOI());
                pdx.setCodeFirst(sdx.isCodeFirst());
                pdx.setUnacceptablePdx(sdx.isUnacceptablePdx());
                pdx.setDescription(sdx.getDescription());
                pdx.setDiagnosisSubchapter(sdx.getDiagnosisSubchapter());
                pdx.setComorbidityGroup(sdx.getComorbidityGroup());
                pdx.setClinicalGroup(sdx.getClinicalGroup());
                pdx.addEdit(new Edit(EditId_EN.VALUE_SUBSTITUTED, pdx + " " + EditId_EN.VALUE_SUBSTITUTED.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
                sdx.addEdit(new Edit(EditId_EN.VALUE_PROMOTED, sdx + " " + EditId_EN.VALUE_PROMOTED.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
                sdx.addEdit(new Edit(EditId_EN.VALUE_IGNORE, sdx + " " + EditId_EN.VALUE_IGNORE.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean calculate() {
        int HIPPS_POSITION = 2;
        String text = null;
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        if (!pdx.getEditCollection().hasCriticalEdits()) {
            text = "PDX = " + pdx.getValue() + " (" + pdx.getDescription() + ")" + (pdx.getEditCollection().hasEditId(EditId_EN.VALUE_SUBSTITUTED) ? " (SDX promoted to PDX)" : "");
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "PDX Clinical Group = " + pdx.getClinicalGroup();
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "PDX Subchapter = " + pdx.getDiagnosisSubchapter().getDxFrom() + "-" + pdx.getDiagnosisSubchapter().getDxTo() + " (" + pdx.getDiagnosisSubchapter().getDescription() + ")";
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            text = "HIPPS Position 2 = " + pdx.getClinicalGroup().getValue() + " (" + pdx.getClinicalGroup().getDescription() + ")";
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
            return this.setHippsCode(2, "" + pdx.getClinicalGroup().getValue());
        }
        text = "PDX has critical issue(s). Please see validation messages";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
        text = "HIPPS Position 2 = 0 (Not calculated)";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS2, text);
        return false;
    }

    protected boolean checkAsPdx(String label, DiagnosisIF pdx) {
        int GRC_INVALID_PDX = 3;
        int GRC_UNGROUPABLE_PDX = 5;
        boolean retFlag = true;
        if (!pdx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID)) {
            ClinicalGroupIF cg = pdx.getClinicalGroup();
            if (cg == null || cg.getValue().isEmpty() || cg.getValue().equalsIgnoreCase("na")) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " has no Clinical Group assigned, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isManifestation()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is manifestation DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isECOI()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is ECOI DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
            if (pdx.isUnacceptablePdx()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, label + " " + pdx + " is unacceptable as PDX DX, " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
                this.addReturnCode(5);
                retFlag = false;
            }
        } else {
            this.addReturnCode(3);
            retFlag = false;
        }
        return retFlag;
    }
}

