/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.v04223;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPosition1;
import gov.cms.hh.logic.specification.IsValidThroughDate;

public class HippsPosition1_v04223
extends HippsPosition1 {
    public HippsPosition1_v04223(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    @Override
    public boolean validate() {
        boolean GRC_INVALID_THROUGH_DATE = true;
        boolean retPrev = super.validate();
        boolean retAdd = this.checkThroughDate(this.getClaim());
        if (!retAdd) {
            this.addReturnCode(1);
        }
        return retPrev && retAdd;
    }

    protected boolean checkThroughDate(ClaimIF claim) {
        int EMPTY = 11;
        int INVALID = 12;
        int PRECEDES = 13;
        int EXCEEDS = 14;
        int SHORTER = 15;
        String pocTemplate = "Period of care is: %s days";
        IsValidThroughDate dateChecker = new IsValidThroughDate(claim.getDateFrom().getValue());
        boolean retFlag = dateChecker.isSatisfiedBy(claim.getDateThrough().getValue());
        if (claim.getDateThrough().getValue() == null || claim.getDateThrough().getValue().trim().isEmpty()) {
            this.addValidityFlag(EMPTY);
        } else if (dateChecker.getThroughDate() == null) {
            this.addValidityFlag(INVALID);
        } else {
            if (dateChecker.isExceeded()) {
                this.addValidityFlag(EXCEEDS);
                this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, String.format(pocTemplate, dateChecker.getPoc()));
            }
            if (dateChecker.isPreceded()) {
                this.addValidityFlag(PRECEDES);
            }
            if (dateChecker.isShorter()) {
                this.addValidityFlag(SHORTER);
                this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS1, String.format(pocTemplate, dateChecker.getPoc()));
            }
        }
        return retFlag;
    }
}

