/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.data.loader;

import gov.cms.hh.data.loader.LineParserIF;
import gov.cms.hh.grouper.utility.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LineParser
implements LineParserIF {
    private static final Logger LOG = Logger.getLogger(LineParser.class.getName());
    private final Function<String, List<String>> parseTo;

    public LineParser(String delimiter) {
        this.parseTo = line -> {
            ArrayList<String> retList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer((String)line, delimiter);
            while (tokenizer.hasMoreTokens()) {
                retList.add(tokenizer.nextToken());
            }
            return retList;
        };
    }

    public LineParser(List<Integer> fieldSizeList) {
        int layoutLen = Utility.sum(fieldSizeList);
        this.parseTo = line -> {
            ArrayList<String> retList = new ArrayList<String>();
            if (layoutLen <= line.length()) {
                int start = 0;
                for (int i = 0; i < fieldSizeList.size(); ++i) {
                    retList.add(line.substring(start, start + (Integer)fieldSizeList.get(i)));
                    start += ((Integer)fieldSizeList.get(i)).intValue();
                }
            } else {
                LOG.log(Level.SEVERE, "Input Record Length error: expected={0}, actual={1}", new Object[]{layoutLen, line.length()});
            }
            return retList;
        };
    }

    public LineParser() {
        this("\t");
    }

    @Override
    public List<String> parseLine(String line) {
        return (List)Stream.of(line).map(this.parseTo).collect(Collectors.toList()).get(0);
    }
}

