/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.loader.DataLoader;
import gov.cms.hh.data.loader.DataLoaderIF;
import gov.cms.hh.grouper.ClaimManagerIF;
import gov.cms.hh.reference.objects.ClaimFieldObject;
import gov.cms.hh.reference.objects.ClaimLayoutObject;
import gov.cms.hh.reference.objects.ClaimObject;
import gov.cms.hh.xml.layout.claim.ClaimField;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClaimManager
implements ClaimManagerIF {
    DataLoaderIF<ClaimObject> claimLoaderFull;
    DataLoaderIF<ClaimObject> claimLoaderShort;
    ClaimLayoutObject claimLayoutObject;
    ClaimLayoutObject claimLayoutInputObject;
    private static final Logger LOG = Logger.getLogger(ClaimManager.class.getName());

    public ClaimManager(String basePath) {
        this.loadClaimLayout(basePath);
    }

    private void loadClaimLayout(String basePath) {
        this.claimLayoutObject = this.buildClaimLayout(basePath + "/" + TableNames_EN.Claim_Layout.getFileName());
        this.claimLoaderFull = new DataLoader<ClaimObject>(ClaimObject.class, this.claimLayoutObject);
        this.claimLayoutInputObject = this.buildInputOnlyLayout(this.claimLayoutObject, "input");
        this.claimLoaderShort = new DataLoader<ClaimObject>(ClaimObject.class, this.claimLayoutInputObject);
        LOG.log(Level.INFO, "Grouper Claim Manager instantiated: RT path: {0}", new Object[]{basePath});
    }

    private ClaimLayoutObject buildClaimLayout(String claimLayoutFile) {
        InputStream inputFile = this.getClass().getClassLoader().getResourceAsStream(claimLayoutFile);
        DataLoader<ClaimFieldObject> dl = new DataLoader<ClaimFieldObject>(ClaimFieldObject.class);
        List<ClaimFieldObject> claimFieldList = dl.loadFile(inputFile, false);
        ClaimLayoutObject clo = new ClaimLayoutObject();
        claimFieldList.forEach(claimFieldObject -> clo.getClaimField().add((ClaimField)claimFieldObject));
        return clo;
    }

    private ClaimLayoutObject buildInputOnlyLayout(ClaimLayoutObject clo, String inputField) {
        ClaimLayoutObject retClo = new ClaimLayoutObject();
        for (ClaimField claimField : clo.getClaimField()) {
            if (!claimField.getType().trim().equalsIgnoreCase(inputField)) continue;
            retClo.getClaimField().add(claimField);
        }
        return retClo;
    }

    @Override
    public List<Integer> getClaimLayout() {
        return this.claimLayoutObject.getLayout();
    }

    @Override
    public List<Integer> getClaimLayoutInputOnly() {
        return this.claimLayoutInputObject.getLayout();
    }

    @Override
    public ClaimObject loadClaim(String claimInput) {
        return this.claimLoaderShort.load(claimInput);
    }
}

