/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.exchange.DxContainerIF;
import gov.cms.hh.data.meta.enumer.Oasis_EN;
import gov.cms.hh.data.meta.enumer.PeriodTiming_EN;
import gov.cms.hh.data.meta.enumer.ReferralSource_EN;
import gov.cms.hh.diagnosis.Diagnosis;
import gov.cms.hh.diagnosis.DiagnosisIF;
import java.util.List;
import java.util.Map;

/**
 *
 * @author CMS
 */
public class ClaimAdapter implements ClaimAdapterIF {

    /**  Convert claim container (PC API):
     * 
     * 1.From Claim Container to Claim (internal claim object) format for grouping
     *  2. From Claim (internal claim) to Claim Container format for utility services
     * - populating results
     * - exporting claim back to fix format
     */ 

    /** @param claimIn
     * 
     * @return 
     */
    @Override
    public ClaimContainerIF convert(ClaimIF claimIn) {
        return null;
    }
    
    /**
     *
     * @param claimIn
     * @return
     */
    @Override
    public ClaimIF convert(final ClaimContainerIF claimIn) {

        final Claim retClaim;
        retClaim = new Claim();

        // ID
        retClaim.setClaimId(claimIn.getClaimId());

        // From Date
        ClaimDate df = new ClaimDate();
        df.setValue(claimIn.getFromDate());
        retClaim.setDateFrom(df);
        
        // Through Date
        ClaimDate dt = new ClaimDate();
        dt.setValue(claimIn.getThroughDate());
        retClaim.setDateThrough(dt);

        // Period Timing
        PeriodTiming pt = new PeriodTiming();
        String ptVal = claimIn.getPeriodTiming();
        pt.setValue(ptVal);
        // get Period Timing Description
        pt.setDescription(getPeriodTimingDescription(ptVal));
        retClaim.setPeriodTiming(pt);

        // Referral Source
        ReferralSource rf = new ReferralSource();
        String rfVal = claimIn.getReferralSource();
        rf.setValue(rfVal);
        // get Referral Source Description
        rf.setDescription(getReferralSourceDescription(rfVal));
        retClaim.setReferralSource(rf);

        // PDX
        DiagnosisIF pdx = new Diagnosis(); // Instantiate "shallow" internal DX object
        if (claimIn.getPdx() != null) {
            pdx.setValue(claimIn.getPdx().getDx().trim().toUpperCase());
        }
        retClaim.setPrimaryDiagnosis(pdx);

        // SDX
        List<DxContainerIF> sdxList = claimIn.getSdxList();
        if (sdxList != null) {
            for (DxContainerIF dx : sdxList) {
                if (dx == null || dx.getDx().trim().isEmpty()) {
                    break; // terminate on blank SDX
//                    continue; // skip blank SDX
                }
                DiagnosisIF sdx = new Diagnosis();
                sdx.setValue(dx.getDx().trim().toUpperCase());
                retClaim.getSecondaryDiagnoses().getCollection().add(sdx);
            }
        }

        // OASIS
        Map<String, String> ffMap = claimIn.getFunctionalFields();
        for (Map.Entry<String, String> entry : ffMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            OasisResponseIF oasisResponse = new OasisResponse();
            oasisResponse.setType(Oasis_EN.valueOf(key));
            oasisResponse.setValue(value);
            retClaim.getOasisFields().getCollection().add(oasisResponse);
        }

        return retClaim;
    }

    private String getPeriodTimingDescription(String inValue) {
        if (inValue == null) {
            return null;
        }
        for (PeriodTiming_EN value : PeriodTiming_EN.values()) {
            if (("" + value.getId()).equalsIgnoreCase(inValue.trim())) {
                return value.getDescription();
            }
        }
        return null;
    }

    private String getReferralSourceDescription(String inValue) {
        if (inValue == null) {
            return null;
        }
        for (ReferralSource_EN value : ReferralSource_EN.values()) {
            if (("" + value.getId()).equalsIgnoreCase(inValue.trim())) {
                return value.getDescription();
            }
        }
        return null;
    }

}
