/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.common.abstr.EditableIF;
import gov.cms.hh.common.abstr.ValidatableIF;
import gov.cms.hh.common.abstr.VerifiableIF;

/**
 *
 * @author CMS
 */
public interface DiagnosisIF extends EditableIF, VerifiableIF, ValidatableIF {

    /**
     * @return the unspecifiedPdx
     */
    public boolean isUnspecifiedPdx();

    /**
     * @param unspecifiedPdx the unspecifiedPdx to set
     */
    public void setUnspecifiedPdx(boolean unspecifiedPdx);
    
    /**
     * @return the predecessor
     */
    public String getPredecessor();
    
    /**
     * @param predecessor the predecessor to set
     */
    public void setPredecessor(String predecessor);    
    
    /**
     * @return the codeFirstCondition
     */
    public CodeFirstConditionIF getCodeFirstCondition();    
    
    /**
     * @param codeFirstCondition the codeFirstCondition to set
     */
    public void setCodeFirstCondition(CodeFirstConditionIF codeFirstCondition);
    
    /**
     * @return the clinicalGroup
     */
    ClinicalGroupIF getClinicalGroup();

    /**
     * @return the comorbidityGroup
     */
    ComorbidityGroupIF getComorbidityGroup();

    /**
     * @return the description
     */
    String getDescription();

    /**
     * @return the diagnosisSubchapter
     */
    DiagnosisSubchapterIF getDiagnosisSubchapter();

    /**
     * @return the id
     */
    int getId();

    /**
     * @return the value
     */
    String getValue();

    /**
     * @return the ECOI
     */
    boolean isECOI();

    /**
     * @return the manifestation
     */
    boolean isManifestation();

    /**
     * @return the primaryAwarding
     */
    boolean isPrimaryAwarding();

    /**
     * @return the codeFirst
     */
    boolean isCodeFirst();

    /**
     * @return the unacceptablePdx
     */
    boolean isUnacceptablePdx();

    /**
     * @param clinicalGroup the clinicalGroup to set
     */
    void setClinicalGroup(ClinicalGroupIF clinicalGroup);

    /**
     * @param comorbidityGroup the comorbidityGroup to set
     */
    void setComorbidityGroup(ComorbidityGroupIF comorbidityGroup);

    /**
     * @param description the description to set
     */
    void setDescription(String description);

    /**
     * @param diagnosisSubchapter the diagnosisSubchapter to set
     */
    void setDiagnosisSubchapter(DiagnosisSubchapterIF diagnosisSubchapter);

    /**
     * @param ECOI the ECOI to set
     */
    void setECOI(boolean ECOI);

    /**
     * @param codeFirst
     */
    void setCodeFirst(boolean codeFirst);

    /**
     * @param unacceptablePdx
     */
    void setUnacceptablePdx(boolean unacceptablePdx);
    
    /**
     * @param id the id to set
     */
    void setId(int id);

    /**
     * @param manifestation the manifestation to set
     */
    void setManifestation(boolean manifestation);

    /**
     * @param primaryAwarding the primaryAwarding to set
     */
    void setPrimaryAwarding(boolean primaryAwarding);

    /**
     * @param value the value to set
     */
    void setValue(String value);

    /**
     * @return the codeFistConditionId
     */
    public int getCodeFistConditionId();

    /**
     * @param codeFistConditionId the codeFistConditionId to set
     */
    public void setCodeFistConditionId(int codeFistConditionId);
    
}
