/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.exchange.ClaimContainerIF;
import java.io.File;
import java.util.List;

/**
 *
 * @author CMS
 */
public interface GrouperFactoryIF {

    /**
     *
     * @return
     */
    String getBuildInfo();
    
    /**
     *
     * @param claimDate
     * @return
     */
    boolean isClaimDateValid(String claimDate);

    /**
     *
     * @param claimDate
     * @param diagValue
     * @return
     */
    String getDiagnosisDescription(String claimDate, String diagValue);

    /**
     *
     * @param claimDate
     * @return
     */
    ClaimContainerIF getEmptyClaim(String claimDate);

    /**
     *
     * @param claim
     */
    void group(ClaimContainerIF claim);

    /**
     *
     * @param input
     * @param output
     */
    void group(File input, File output);
    
    /**
     *
     * @param input
     * @param output
     * @param fullRecord
     */
    void group(File input, File output, boolean fullRecord);
    
    /**
     *
     * @param claimInput
     * @return
     */
    String group(String claimInput);
    
    /**
     *
     * @param claimInput
     * @param fullRecord
     * @return
     */
    String group(String claimInput, boolean fullRecord);
    
    /**
     *
     * @return
     */
    List<GrouperIF> getAvailableVersions();
    
    /**
     *
     * @return
     */
    GrouperIF getDefaultGrouper();
    
}
