/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author CMS
 */
public class IsCodeValid extends AbstractSpecification<GrouperIF> {

    private final String value;
    private final TableNames_EN type;

    /**
     *
     * @param value
     * @param type
     */
    public IsCodeValid(String value, TableNames_EN type) {
        this.value = value;
        this.type = type;
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return gv.getAvailableTableContent(type).getDataMap().containsKey(value);
    }

}
