/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.diagnosis.ComorbidityGroupIF;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.util.List;

/**
 *
 * @author CMS
 */
public class IsInComorbidityInteraction extends AbstractSpecification<ComorbidityGroupIF> {

    private final List<DiagnosisIF> dxList;

    /**
     *
     * @param dxList
     */
    public IsInComorbidityInteraction(List<DiagnosisIF> dxList) {
        this.dxList = dxList;
    }

    /**
     *
     * @param comorbidity
     * @return
     */
    @Override
    public boolean isSatisfiedBy(ComorbidityGroupIF comorbidity) {
        if(dxList == null) {
            return false;
        }
        for (DiagnosisIF dx : dxList) {
            if(dx.getComorbidityGroup().getName().trim()
                    .equalsIgnoreCase(comorbidity.getName().trim())) {
                return true;
            }
        }
        // not found
        return false;
    }

}
