/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.meta.MetaData;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractClaimDateValidator;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

/**
 *
 * @author CMS
 */
public class IsSpanClaim extends AbstractClaimDateValidator {

    public IsSpanClaim(String date) {
        super(date);
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDaysInRange(gv.getEndDate());
    }

    /**
     *
     * @param end
     * @return
     */
    protected boolean isDaysInRange(final Date end) {
        if (getDate() == null) {
            return false;
        }
        // Convert to Local Date as more safe for day range calculation 
        LocalDate startDate = getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // Calculate span in days 
        long days = ChronoUnit.DAYS.between(startDate, endDate);
        return (days < MetaData.SPAN_CLAIM_RANGE_IN_DAYS);
    }

}
