/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification.abstr;

import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author CMS
 * @param <T>
 */
public class AndSpecification<T> extends AbstractSpecification<T> {

    private final Set<Specification<T>> set;

    /**
     *
     * @param a
     * @param b
     */
    public AndSpecification(Specification<T> a, Specification<T> b) {
        this.set = new HashSet<>();
        set.add(a);
        set.add(b);
    }

    /**
     *
     * @param t
     * @return
     */
    @Override
    public boolean isSatisfiedBy(T t) {
        for (Specification<T> s : set) {
            if (!s.isSatisfiedBy(t)) {
                return false;
            }
        }
        return true;
    }

    /**
     *
     * @param s
     * @return
     */
    @Override
    public AbstractSpecification<T> and(Specification<T> s) {
        set.add(s);
        return this;
    }

}
