
package gov.cms.hh.logic.specification.condition;

import gov.cms.hh.logic.specification.abstr.Specification;

/**
 *
 * @author CMS
 */
public class ConditionChecker {

    private final Specification<String> codeFirstConditions;
    
    /**
     *
     * @param conditions
     */
    public ConditionChecker(String conditions) {
        ConditionSpecificationBuilder cb = 
                new ConditionSpecificationBuilder();
        this.codeFirstConditions = cb.buildConditionSpecifications(conditions);
    }
    
    /**
     *
     * @param dx
     * @return
     */
    public boolean isCodeFirstConditionSatisfied(String dx) {
        return codeFirstConditions.isSatisfiedBy(dx);
    }
    
}
