/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification.condition;

import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author CMS
 */
public class RegexCondition extends AbstractSpecification<String> {

    private final String range;

    /**
     *
     * @param range
     */
    public RegexCondition(String range) {
        this.range = range;
    }

    /**
     *
     * @param dx
     * @return
     */
    @Override
    public boolean isSatisfiedBy(String dx) {
        if(dx.trim().isEmpty()) {
            return false; // "Empty" DX doesn't meet any range
        }
        if(range.trim().isEmpty()) {
            return true; // Any DX meets "empty" range - Specs for v04.1.23
        }
        Pattern pattern = Pattern.compile(range.trim().toUpperCase());
        Matcher matcher = pattern.matcher(dx.trim().toUpperCase());
        boolean matchFound = matcher.find();
        return matchFound;
    }

}
