/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.xml.layout.rot.DiagnosisSubchapter;
import gov.cms.hh.data.loader.PositionAccessorIF;

/**
 *
 * @author CMS
 */
public class DiagnosisSubchapterObject extends DiagnosisSubchapter implements PositionAccessorIF{

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "DX SubChapter ID:'" + getId() +
                "', DX From:'" + getDiagnosisFrom() +
                "', DX To:'" + getDiagnosisTo() +
                "', DX SubChapter Description:'" + getDescription() +
                "'";
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getDiagnosisFrom();
            case 2:
                return getDiagnosisTo();
            case 3:
                return getDescription();
            default:
                return null; // Exception???
        }
    }

    /**
     *
     * @param position
     * @param value
     * @return
     */
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setDiagnosisFrom(value);
                return true;
            case 2:
                setDiagnosisTo(value);
                return true;
            case 3:
                setDescription(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 4;
    }

    /**
     *
     * @param value
     */
    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

}
