/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */

package gov.cms.hh.v04123;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsProcessorIF;
import gov.cms.hh.v04023.*;
import gov.cms.hh.reference.objects.GrouperVersionObject;

import java.text.ParseException;

/**
 *
 * @author CMS
 */
public class Grouper_v04123 extends Grouper_v04023 {

    /**
     *
     * @param id
     * @param grouperVersionObject
     * @param loadDescription
     * @throws ParseException
     */
    public Grouper_v04123(Integer id, GrouperVersionObject grouperVersionObject, Boolean loadDescription) throws ParseException {
        super(id, grouperVersionObject, loadDescription);
    }
    
    /**
     *
     * @param claim
     * @param dataManager
     */
    @Override
    protected void processClaim(final ClaimIF claim, final DataManagerIF dataManager) {
        HippsProcessorIF hp;
        hp = new HippsProcessor_v04123();
        hp.process(claim, dataManager);
    }
    
} 

