/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.v05024;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsProcessorIF;
import gov.cms.hh.logic.specification.IsCodeValid;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.v04223.*;
import gov.cms.hh.reference.objects.GrouperVersionObject;
import java.text.ParseException;
import java.util.logging.Level;

/**
 *
 * @author CMS
 */
public class Grouper_v05024 extends Grouper_v04223 {

    /**
     *
     * @param id
     * @param grouperVersionObject
     * @param loadDescription
     * @throws ParseException
     */
    public Grouper_v05024(Integer id, GrouperVersionObject grouperVersionObject, Boolean loadDescription) throws ParseException {
        super(id, grouperVersionObject, loadDescription);
    }

    /**
     * Claim caster method for potential span claims HHGS requirements for
     * October 2024 Get parent DXs for SDXx
     *
     * @param claimInput
     * @return
     */
    @Override
    protected ClaimIF castClaim(final ClaimContainerIF claimInput) {
        ClaimIF claim = super.castClaim(claimInput);

        // Check for span claim and potential SDX substitution
        // Specs for v05.1.24 in relation to v05.0.24
        // It could have a valid PDX initially or updated PDX
        // Still have to be linked
        if (!isLinked()) {
            return claim;
        }

        // Still have to be spanning
        if (!isSpanningClaim(claim)) {
            return claim;
        }

        // Check newer SDXs (if any) for potential parent SDXs
        for (DiagnosisIF sdx : claim.getSecondaryDiagnoses().getCollection()) {
            // Check if SDX valid and do nothing if it is
            boolean isSdxValid = (new IsCodeValid(sdx.getValue(), TableNames_EN.Diagnoses)).isSatisfiedBy(this);
            if (!isSdxValid) {
                // Check next version for potential parent SDXs
                boolean isSdxNextValid = (new IsCodeValid(sdx.getValue(), TableNames_EN.Diagnoses)).isSatisfiedBy(getNextVersion());
                if (isSdxNextValid) {
                    // try to get the predecessor DX
                    String predecessorDx = getPredecessorDx(sdx.getValue());
                    // substitute SDX with predecessor DX
                    sdx.setValue(predecessorDx);
                    sdx.addEdit(new Edit(EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN, sdx + ", "
                            + EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN.getDescription(),
                            EditType_EN.SPECIFICATION, Level.INFO));
                }
            }
        }

        // Return claim with updated SDXs (if found)
        return claim;
    }

    /**
     *
     * @param claim
     * @param dataManager
     */
    @Override
    protected void processClaim(final ClaimIF claim, final DataManagerIF dataManager) {
        HippsProcessorIF hp;
        hp = new HippsProcessor_v05024();
        hp.process(claim, dataManager);
    }
}
