/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper.utility;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utility {
    static final String DELIMITER_COMMA = ",";
    static final String DELIMITER_TAB = "\t";
    private static final Logger LOG = Logger.getLogger(Utility.class.getName());

    public static int sum(List<Integer> list) {
        if (list == null || list.size() < 1) {
            return 0;
        }
        int sum = 0;
        for (Integer i : list) {
            sum += i.intValue();
        }
        return sum;
    }

    public static String join(List<String> list) {
        return Utility.join(list, DELIMITER_COMMA);
    }

    public static String join(List<String> list, String delimiter) {
        if (list == null) {
            return null;
        }
        String del = delimiter == null ? DELIMITER_COMMA : delimiter;
        StringJoiner joiner = new StringJoiner(del);
        list.forEach(s -> joiner.add((CharSequence)s));
        return joiner.toString();
    }

    public static void detectJvm() {
        LOG.info("***** Java configuration *****");
        Properties p = System.getProperties();
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)p.get(key);
            LOG.log(Level.INFO, "{0}: {1}", new Object[]{key, value});
        }
    }

    public static String adjustLine(String s, int n) {
        if (s.length() == n) {
            return s;
        }
        String line = s.length() > n ? s.substring(0, n) : Utility.padRight(s, n);
        return line;
    }

    public static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%" + n + "s", s);
    }

    public static Date processDate(String inpDate) {
        if (inpDate == null) {
            return null;
        }
        String date = inpDate.replaceAll(" ", "x");
        if (!Utility.isInteger(date)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setLenient(false);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean isInteger(String value) {
        try {
            Long.valueOf(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

