/*
 * Decompiled with CFR 0.152.
 */
package com.utilities;

import com.App;
import com.Controller;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);

    public static void clearLog() {
        if (!App.isDebug) {
            try {
                PrintWriter writer = new PrintWriter("log.txt");
                writer.print("");
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void logButtonPress(ActionEvent e) {
        if (!App.isDebug) {
            Object o = e.getSource();
            ERROR_LEVEL error = ERROR_LEVEL.DEBUG;
            if (o instanceof Button) {
                Log.l(((Button)o).getText() + " button pressed.", error);
            } else if (o instanceof MenuItem) {
                Log.l(((MenuItem)o).getText() + " button pressed.", error);
            } else {
                Log.l("Unknown button pressed.", error);
            }
        }
    }

    public static void logTextField(TextField t) {
        if (!App.isDebug) {
            Log.l(t.getId() + " -> " + t.getText(), ERROR_LEVEL.DEBUG);
        }
    }

    public static void l(String s, ERROR_LEVEL l) {
        if (!App.isDebug) {
            switch (l) {
                case INFO: {
                    logger.info(s);
                    break;
                }
                case WARN: {
                    logger.warn(s);
                    break;
                }
                case DEBUG: {
                    logger.debug(s);
                    break;
                }
                case ERROR: {
                    logger.error(s);
                    break;
                }
            }
        }
    }

    static String readLogFile() {
        try {
            return new String(Files.readAllBytes(new File("log.txt").toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Error - Log Could Not Be Read";
        }
    }

    public static void writeToFile(File f) {
        File outputFile = new File(f.getAbsolutePath());
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write(new String(Files.readAllBytes(new File("log.txt").toPath()), StandardCharsets.UTF_8));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum ERROR_LEVEL {
        INFO,
        WARN,
        DEBUG,
        ERROR;

    }
}

