/*
 * Decompiled with CFR 0.152.
 */
package com.utilities.formattor;

import javafx.scene.control.TextField;

public class NumericFormattor {
    private final TextField inputField;

    public NumericFormattor(Object o, int fieldLength) {
        this.inputField = (TextField)o;
        this.checkType(this.inputField.getText(), fieldLength);
    }

    private void checkType(String s, int fieldLength) {
        try {
            String input = String.valueOf(Integer.valueOf(s));
            this.inputField.setText(this.checkLength(input, fieldLength));
            this.inputField.positionCaret(this.inputField.getText().length());
        }
        catch (NumberFormatException e) {
            if (s.length() > 0) {
                this.inputField.positionCaret(s.length() - 1);
                this.inputField.setText(this.inputField.getText().substring(0, s.length() - 1));
            }
            this.inputField.positionCaret(0);
        }
    }

    private String checkLength(String s, int maxLength) {
        if (this.inputField.getText().length() > maxLength) {
            return this.inputField.getText().substring(0, maxLength);
        }
        return s;
    }
}

