/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.claim;

import gov.cms.hh.claim.ClaimElementBase;
import gov.cms.hh.claim.HippsCodeIF;
import gov.cms.hh.reference.objects.HippsValueObject;
import java.util.Map;
import java.util.TreeMap;

public class HippsCode
extends ClaimElementBase
implements HippsCodeIF {
    private static final long serialVersionUID = 1L;
    final String HIPPS_INIT_CHAR = "0";
    final int HIIPS_DIGITS_TO_CHECK = 4;
    private Map<Integer, HippsValueObject> hipps = new TreeMap<Integer, HippsValueObject>();

    public String toString() {
        return "HippsCode{hipps=" + this.hipps + "}";
    }

    public HippsCode() {
        for (int i = 1; i <= 5; ++i) {
            HippsValueObject filler = new HippsValueObject();
            filler.setPosition("" + i);
            filler.setPositionDescription("Position " + i);
            filler.setValue("0");
            filler.setValueDescription("Init value");
            this.hipps.put(i, filler);
        }
    }

    @Override
    public Map<Integer, HippsValueObject> getHipps() {
        return this.hipps;
    }

    @Override
    public void setHipps(Map<Integer, HippsValueObject> hipps) {
        this.hipps = hipps;
    }

    @Override
    public boolean setValue(HippsValueObject value) {
        int position = Integer.parseInt(value.getPosition());
        if (position < 1 || position > 5) {
            return false;
        }
        this.hipps.put(position, value);
        return true;
    }

    @Override
    public String getHippsCode() {
        StringBuilder ret = new StringBuilder();
        this.hipps.values().forEach(value -> ret.append(value.getValue()));
        return ret.toString();
    }

    @Override
    public String getHippsCharacter(int position) {
        return this.getValue(position).getValue();
    }

    @Override
    public HippsValueObject getValue(int position) {
        if (position < 1 || position > 5) {
            return null;
        }
        if (this.hipps != null) {
            return this.hipps.get(position);
        }
        return null;
    }

    @Override
    public boolean isHippsComplete() {
        for (int i = 1; i <= 4; ++i) {
            if (!this.getHippsCharacter(i).equals("0")) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getFinalHippsCode() {
        if (this.isHippsComplete()) {
            return this.getHippsCode();
        }
        return "00000";
    }
}

