/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.diagnosis.ComorbidityGroupIF;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.util.List;

public class IsInComorbidityInteraction
extends AbstractSpecification<ComorbidityGroupIF> {
    private final List<DiagnosisIF> dxList;

    public IsInComorbidityInteraction(List<DiagnosisIF> dxList) {
        this.dxList = dxList;
    }

    @Override
    public boolean isSatisfiedBy(ComorbidityGroupIF comorbidity) {
        if (this.dxList == null) {
            return false;
        }
        for (DiagnosisIF dx : this.dxList) {
            if (!dx.getComorbidityGroup().getName().trim().equalsIgnoreCase(comorbidity.getName().trim())) continue;
            return true;
        }
        return false;
    }
}

