/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.grouper.utility.Utility;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class IsValidThroughDate
extends AbstractSpecification<String> {
    private Date fromDate = null;
    private Date throughDate = null;
    private boolean exceeded = false;
    private boolean preceded = false;
    private boolean shorter = false;
    private long days;

    public Date getThroughDate() {
        return this.throughDate;
    }

    public boolean isExceeded() {
        return this.exceeded;
    }

    public boolean isPreceded() {
        return this.preceded;
    }

    public IsValidThroughDate(String fromDate) {
        this.fromDate = this.processDate(fromDate);
    }

    private Date processDate(String date) {
        return Utility.processDate(date);
    }

    @Override
    public boolean isSatisfiedBy(String throughDate) {
        this.throughDate = this.processDate(throughDate);
        return this.isDaysInRange(throughDate);
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    protected boolean isDaysInRange(String date) {
        if (this.getFromDate() == null || this.getThroughDate() == null) {
            return false;
        }
        LocalDate startDate = this.getFromDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = this.getThroughDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        this.days = ChronoUnit.DAYS.between(startDate, endDate);
        this.exceeded = this.days > 29L;
        this.preceded = this.days < 0L;
        this.shorter = this.days >= 0L && this.days < 29L;
        return !this.exceeded && !this.preceded;
    }

    public boolean isShorter() {
        return this.shorter;
    }

    public long getPoc() {
        return this.days + 1L;
    }
}

