/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.reference.objects.CodeFirstConditionObject;
import java.text.ParseException;

/**
 *
 * @author CMS
 */
public class CodeFirstCondition implements CodeFirstConditionIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "CodeFirstCondition{" + "id=" + id + ", description=" + description + ", value=" + value  + '}';
    }

    /**
     * Constructor
     */
    public CodeFirstCondition() {
    }

    /**
     *
     * @param id
     * @param description
     * @param value
     * 
     */
    public CodeFirstCondition(int id, String description, String value) {
        this.id = id;
        this.description = description;
        this.value = value;
    }

    /**
     *
     * @param cfco
     * @throws ParseException
     */
    public CodeFirstCondition(CodeFirstConditionObject cfco) throws ParseException {
        this(Integer.parseInt(cfco.getId()), cfco.getDescription(), cfco.getRange());
    }
    
    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    private int id;
    private String value;
    private String description;

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }
    
}
