/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.loader.DataLoaderIF;
import gov.cms.hh.data.loader.DataLoader;
import gov.cms.hh.reference.objects.ClaimFieldObject;
import gov.cms.hh.reference.objects.ClaimLayoutObject;
import gov.cms.hh.reference.objects.ClaimObject;
import gov.cms.hh.xml.layout.claim.ClaimField;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author CMS
 */
public class ClaimManager implements ClaimManagerIF {

    DataLoaderIF<ClaimObject> claimLoaderFull;
    DataLoaderIF<ClaimObject> claimLoaderShort;
    ClaimLayoutObject claimLayoutObject;
    ClaimLayoutObject claimLayoutInputObject;
    
    private static final Logger LOG = Logger.getLogger(ClaimManager.class.getName());

    /**
     *
     * @param basePath
     */
    public ClaimManager(String basePath) {
        loadClaimLayout(basePath);
    }

    // load claim layout
    private void loadClaimLayout(String basePath) {
        
        claimLayoutObject = buildClaimLayout(basePath + "/" + TableNames_EN.Claim_Layout.getFileName());
        
        // Build Claim Reader for all Claim fields
        claimLoaderFull = new DataLoader(ClaimObject.class, claimLayoutObject);
        
        // Build Claim Reader for Claim Input fields only
        claimLayoutInputObject = buildInputOnlyLayout(claimLayoutObject, "input");
        claimLoaderShort = new DataLoader(ClaimObject.class, claimLayoutInputObject);
        
        LOG.log(Level.INFO, "Grouper Claim Manager instantiated: RT path: {0}", new Object[]{basePath});

    }

    private ClaimLayoutObject buildClaimLayout(String claimLayoutFile) {
        
//        LOG.log(Level.INFO, "Build claim layout from: {0} file", claimLayoutFile);
        
        // Claim Layout ROT
        InputStream inputFile = this.getClass().getClassLoader().getResourceAsStream(claimLayoutFile);
        DataLoader<ClaimFieldObject> dl = new DataLoader(ClaimFieldObject.class);
        List<ClaimFieldObject> claimFieldList = dl.loadFile(inputFile, false);

        // Get Claim Record Layout
        ClaimLayoutObject clo = new ClaimLayoutObject();
        claimFieldList.forEach((claimFieldObject) -> {
            clo.getClaimField().add(claimFieldObject);
        });
        return clo;
    }

    private ClaimLayoutObject buildInputOnlyLayout(ClaimLayoutObject clo, String inputField) {
        ClaimLayoutObject retClo = new ClaimLayoutObject();
        for (ClaimField claimField : clo.getClaimField()) {
            if(claimField.getType().trim().equalsIgnoreCase(inputField)) {
                retClo.getClaimField().add(claimField);
            }
        }
        return retClo;
    }

    /**
     *
     * @return
     */
    @Override
    public List<Integer> getClaimLayout() {
        return claimLayoutObject.getLayout();
    }

    /**
     *
     * @return
     */
    @Override
    public List<Integer> getClaimLayoutInputOnly() {
        return claimLayoutInputObject.getLayout();
    }
    
    /**
     *
     * @param claimInput
     * @return
     */
    @Override
    public ClaimObject loadClaim(String claimInput) {
        return claimLoaderShort.load(claimInput);
    }

    
}
