/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper;

import java.util.List;
import java.util.Map;

/**
 *
 * @author CMS
 * @param <T>
 */
public interface DataContainerIF<T> {

    /**
     *
     * @param key
     * @param data
     */
    void add(String key, T data);

    /**
     *
     * @param data
     */
    void addAllWithId(List<T> data);
    
    /**
     *
     * @param keyPosition
     * @param data
     */
    void addAll(int keyPosition, List<T> data);

    /**
     *
     * @param data
     */
    void replaceAllWithId(List<T> data);
    
    /**
     *
     * @param keyPosition
     * @param data
     */
    void replaceAll(int keyPosition, List<T> data);
    
    /**
     * @return the columnNames
     */
    T getColumnNames();

    /**
     * @return the dataMap
     */
    Map<String, T> getDataMap();
    
    /**
     *
     * @return
     */
    List<T> getData();

    /**
     * @param columnNames the columnNames to set
     */
    void setColumnNames(T columnNames);

    /**
     * @param dataMap the dataMap to set
     */
    void setDataMap(Map<String, T> dataMap);
    
}
