/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author CMS
 */
public class HippsProcessor implements HippsProcessorIF {

    /**
     *
     * Process claim
     * @param claim
     * @param dataManager
     */
    @Override
    public void process(final ClaimIF claim, final DataManagerIF dataManager) {
        // Execute steps in order
        executeLogic(buildLogic(claim, dataManager));
    }

    
    protected Map<Integer,HippsPositionIF> buildLogic(final ClaimIF claim, final DataManagerIF dataManager) {
        // Build HIPPS position logic pool
        Map<Integer,HippsPositionIF> retSteps = new TreeMap<>();
        
        List<HippsPositionIF> steps = Arrays.asList(
            new HippsPosition1(claim, dataManager),
            new HippsPosition2(claim, dataManager),
            new HippsPosition3(claim, dataManager),
            new HippsPosition4(claim, dataManager),
            new HippsPosition5(claim, dataManager)
        );
            
        for (HippsPositionIF step : steps) {
            retSteps.put(step.getOrder(), step);
        }
        
        return retSteps;
    }
    
    /**
     *
     * @param steps
     */
    protected void executeLogic(Map<Integer,HippsPositionIF> steps) {

        // Execute steps sequentially
        for (Integer position : steps.keySet()) {
            HippsPositionIF step = steps.get(position);
            // Execute logic of each step
            step.validate();
            step.calculate();
        }

    }

}
