/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.meta.enumer.PeriodTiming_EN;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author CMS
 */
public class IsValidPeriodTiming extends AbstractSpecification<PeriodTiming_EN[]> {

	private final String value;
	
    /**
     *
     * @param value
     */
    public IsValidPeriodTiming(String value) {
		this.value = value;
	}
	
    /**
     *
     * @param periodTiming
     * @return
     */
    @Override
	public boolean isSatisfiedBy(PeriodTiming_EN[] periodTiming) {
            if(value == null) {
                return false;
            }
            for (PeriodTiming_EN val : PeriodTiming_EN.values()) {
                if(value.trim().equalsIgnoreCase("" + val.getId())) {
                    return true;
                }
            }
            return false;
	}

}
