/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification.abstr;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.grouper.utility.Utility;
import java.util.Date;

/**
 *
 * @author CMS
 */
public abstract class AbstractClaimDateValidator extends AbstractSpecification<GrouperIF> {

    private Date date = null;

    /**
     *
     * @param dateIn
     */
    public AbstractClaimDateValidator(String dateIn) {
        this.date = processDate(dateIn);
    }

    private Date processDate(String dateIn) {
        return Utility.processDate(dateIn);
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public abstract boolean isSatisfiedBy(GrouperIF gv);

    public Date getDate() {
        return date;
    }

}
