/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.xml.layout.rot.ValidityFlag;
import gov.cms.hh.data.loader.PositionAccessorIF;

/**
 *
 * @author CMS
 */
public class ValidityFlagObject extends ValidityFlag implements PositionAccessorIF{

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Validity Flag:'" + getFlag() +
                "', Description:'" + getDescription() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getFlag();
            case 1:
                return getDescription();
            default:
                return null; // Exception???
        }
    }

    /**
     *
     * @param position
     * @param value
     * @return
     */
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setFlag(value);
                return true;
            case 1:
                setDescription(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 2;
    }

    /**
     *
     * @param value
     */
    @Override
    public void setDescription(String value) {
        if (isLoadDescription()) {
            super.setDescription(value);
        }
    }
    
    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

}
