/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.ser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.module.blackbird.ser.BooleanPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.IntPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.LongPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.ObjectPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.SerializerUtil;
import com.fasterxml.jackson.module.blackbird.ser.StringPropertyWriter;
import com.fasterxml.jackson.module.blackbird.ser.ToBooleanFunction;
import com.fasterxml.jackson.module.blackbird.util.ReflectionHack;
import com.fasterxml.jackson.module.blackbird.util.Unchecked;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;

public class BBSerializerModifier
extends BeanSerializerModifier {
    private static final long serialVersionUID = 1L;
    private final Function<Class<?>, MethodHandles.Lookup> _lookups;
    private final UnaryOperator<MethodHandles.Lookup> _accessGrant;

    public BBSerializerModifier(Function<Class<?>, MethodHandles.Lookup> lookups, UnaryOperator<MethodHandles.Lookup> accessGrant) {
        this._lookups = lookups;
        this._accessGrant = accessGrant;
    }

    @Override
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        Class<?> beanClass = beanDesc.getBeanClass();
        if (Modifier.isPrivate(beanClass.getModifiers())) {
            return beanProperties;
        }
        this.findProperties(beanClass, config, beanProperties);
        return beanProperties;
    }

    protected void findProperties(Class<?> beanClass, SerializationConfig config, List<BeanPropertyWriter> beanProperties) {
        MethodHandles.Lookup lookup = this._lookups.apply(beanClass);
        if (lookup == null) {
            return;
        }
        ListIterator<BeanPropertyWriter> it = beanProperties.listIterator();
        while (it.hasNext()) {
            Unchecked.runnable(() -> this.createProperty(it, ReflectionHack.privateLookupIn(beanClass, lookup), config)).run();
        }
    }

    protected void createProperty(ListIterator<BeanPropertyWriter> it, MethodHandles.Lookup lookup, SerializationConfig config) throws Throwable {
        BeanPropertyWriter bpw = it.next();
        AnnotatedMember member = bpw.getMember();
        Member jdkMember = member.getMember();
        if (jdkMember == null) {
            return;
        }
        if (Modifier.isPrivate(jdkMember.getModifiers())) {
            return;
        }
        if (bpw.hasSerializer() && !SerializerUtil.isDefaultSerializer(bpw.getSerializer())) {
            return;
        }
        if (bpw.isUnwrapping()) {
            return;
        }
        if (!bpw.getClass().isAnnotationPresent(JacksonStdImpl.class)) {
            return;
        }
        Class<?> type = bpw.getMember().getRawType();
        if (!(member instanceof AnnotatedMethod)) {
            return;
        }
        MethodHandle getter = lookup.unreflect((Method)member.getMember());
        lookup = (MethodHandles.Lookup)this._accessGrant.apply(lookup);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                ToIntFunction accessor = LambdaMetafactory.metafactory(lookup, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), getter, getter.type()).getTarget().invokeExact();
                it.set(new IntPropertyWriter(bpw, accessor, null));
            } else if (type == Long.TYPE) {
                ToLongFunction accessor = LambdaMetafactory.metafactory(lookup, "applyAsLong", MethodType.methodType(ToLongFunction.class), MethodType.methodType(Long.TYPE, Object.class), getter, getter.type()).getTarget().invokeExact();
                it.set(new LongPropertyWriter(bpw, accessor, null));
            } else if (type == Boolean.TYPE) {
                ToBooleanFunction accessor = LambdaMetafactory.metafactory(lookup, "applyAsBoolean", MethodType.methodType(ToBooleanFunction.class), MethodType.methodType(Boolean.TYPE, Object.class), getter, getter.type()).getTarget().invokeExact();
                it.set(new BooleanPropertyWriter(bpw, accessor, null));
            }
        } else if (type == String.class) {
            Function accessor = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), getter, getter.type()).getTarget().invokeExact();
            it.set(new StringPropertyWriter(bpw, accessor, null));
        } else {
            Function accessor = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), getter, getter.type()).getTarget().invokeExact();
            it.set(new ObjectPropertyWriter(bpw, accessor, null));
        }
    }
}

