/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.time.LocalDate;
import lombok.Generated;

@Schema(description="The rate data associated with an ambulatory payment classification code.")
public class AmbulatoryPaymentClassificationRateData {
    @Pattern(regexp="0\\d{4}")
    @Schema(description="The ambulatory payment classification code.", example="04321", required=true)
    private @Pattern(regexp="0\\d{4}") String ambulatoryPaymentClassificationCode;
    @Schema(description="The effective date of the ambulatory payment classification rate.", example="2020-10-20", required=true)
    @StrictLocalDate
    private LocalDate effectiveDate;
    @BigDecimalScale
    @DecimalMax(value="99999.99")
    @DecimalMin(value="0")
    @Digits(integer=5, fraction=2)
    @Schema(description="The minimum coinsurance rate.", example="12345.99", required=true)
    private @DecimalMax(value="99999.99") @DecimalMin(value="0") @Digits(integer=5, fraction=2) BigDecimal minimumCoinsuranceRate;
    @BigDecimalScale
    @DecimalMax(value="99999.99")
    @DecimalMin(value="0")
    @Digits(integer=5, fraction=2)
    @Schema(description="The national coinsurance rate.", example="12345.99", required=true)
    private @DecimalMax(value="99999.99") @DecimalMin(value="0") @Digits(integer=5, fraction=2) BigDecimal nationalCoinsuranceRate;
    @BigDecimalScale
    @DecimalMax(value="999999.99")
    @DecimalMin(value="0")
    @Digits(integer=6, fraction=2)
    @Schema(description="The payment rate.", example="123456.99", required=true)
    private @DecimalMax(value="999999.99") @DecimalMin(value="0") @Digits(integer=6, fraction=2) BigDecimal paymentRate;
    @Pattern(regexp="[A-Z]\\d?")
    @Schema(description="The status indicator.", example="J2", required=true)
    private @Pattern(regexp="[A-Z]\\d?") String statusIndicator;

    @Generated
    public String getAmbulatoryPaymentClassificationCode() {
        return this.ambulatoryPaymentClassificationCode;
    }

    @Generated
    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public BigDecimal getMinimumCoinsuranceRate() {
        return this.minimumCoinsuranceRate;
    }

    @Generated
    public BigDecimal getNationalCoinsuranceRate() {
        return this.nationalCoinsuranceRate;
    }

    @Generated
    public BigDecimal getPaymentRate() {
        return this.paymentRate;
    }

    @Generated
    public String getStatusIndicator() {
        return this.statusIndicator;
    }

    @Generated
    public void setAmbulatoryPaymentClassificationCode(String ambulatoryPaymentClassificationCode) {
        this.ambulatoryPaymentClassificationCode = ambulatoryPaymentClassificationCode;
    }

    @Generated
    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Generated
    public void setMinimumCoinsuranceRate(BigDecimal minimumCoinsuranceRate) {
        this.minimumCoinsuranceRate = minimumCoinsuranceRate;
    }

    @Generated
    public void setNationalCoinsuranceRate(BigDecimal nationalCoinsuranceRate) {
        this.nationalCoinsuranceRate = nationalCoinsuranceRate;
    }

    @Generated
    public void setPaymentRate(BigDecimal paymentRate) {
        this.paymentRate = paymentRate;
    }

    @Generated
    public void setStatusIndicator(String statusIndicator) {
        this.statusIndicator = statusIndicator;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AmbulatoryPaymentClassificationRateData)) {
            return false;
        }
        AmbulatoryPaymentClassificationRateData other = (AmbulatoryPaymentClassificationRateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ambulatoryPaymentClassificationCode = this.getAmbulatoryPaymentClassificationCode();
        String other$ambulatoryPaymentClassificationCode = other.getAmbulatoryPaymentClassificationCode();
        if (this$ambulatoryPaymentClassificationCode == null ? other$ambulatoryPaymentClassificationCode != null : !this$ambulatoryPaymentClassificationCode.equals(other$ambulatoryPaymentClassificationCode)) {
            return false;
        }
        LocalDate this$effectiveDate = this.getEffectiveDate();
        LocalDate other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        BigDecimal this$minimumCoinsuranceRate = this.getMinimumCoinsuranceRate();
        BigDecimal other$minimumCoinsuranceRate = other.getMinimumCoinsuranceRate();
        if (this$minimumCoinsuranceRate == null ? other$minimumCoinsuranceRate != null : !((Object)this$minimumCoinsuranceRate).equals(other$minimumCoinsuranceRate)) {
            return false;
        }
        BigDecimal this$nationalCoinsuranceRate = this.getNationalCoinsuranceRate();
        BigDecimal other$nationalCoinsuranceRate = other.getNationalCoinsuranceRate();
        if (this$nationalCoinsuranceRate == null ? other$nationalCoinsuranceRate != null : !((Object)this$nationalCoinsuranceRate).equals(other$nationalCoinsuranceRate)) {
            return false;
        }
        BigDecimal this$paymentRate = this.getPaymentRate();
        BigDecimal other$paymentRate = other.getPaymentRate();
        if (this$paymentRate == null ? other$paymentRate != null : !((Object)this$paymentRate).equals(other$paymentRate)) {
            return false;
        }
        String this$statusIndicator = this.getStatusIndicator();
        String other$statusIndicator = other.getStatusIndicator();
        return !(this$statusIndicator == null ? other$statusIndicator != null : !this$statusIndicator.equals(other$statusIndicator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AmbulatoryPaymentClassificationRateData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ambulatoryPaymentClassificationCode = this.getAmbulatoryPaymentClassificationCode();
        result = result * 59 + ($ambulatoryPaymentClassificationCode == null ? 43 : $ambulatoryPaymentClassificationCode.hashCode());
        LocalDate $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        BigDecimal $minimumCoinsuranceRate = this.getMinimumCoinsuranceRate();
        result = result * 59 + ($minimumCoinsuranceRate == null ? 43 : ((Object)$minimumCoinsuranceRate).hashCode());
        BigDecimal $nationalCoinsuranceRate = this.getNationalCoinsuranceRate();
        result = result * 59 + ($nationalCoinsuranceRate == null ? 43 : ((Object)$nationalCoinsuranceRate).hashCode());
        BigDecimal $paymentRate = this.getPaymentRate();
        result = result * 59 + ($paymentRate == null ? 43 : ((Object)$paymentRate).hashCode());
        String $statusIndicator = this.getStatusIndicator();
        result = result * 59 + ($statusIndicator == null ? 43 : $statusIndicator.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AmbulatoryPaymentClassificationRateData(ambulatoryPaymentClassificationCode=" + this.getAmbulatoryPaymentClassificationCode() + ", effectiveDate=" + this.getEffectiveDate() + ", minimumCoinsuranceRate=" + this.getMinimumCoinsuranceRate() + ", nationalCoinsuranceRate=" + this.getNationalCoinsuranceRate() + ", paymentRate=" + this.getPaymentRate() + ", statusIndicator=" + this.getStatusIndicator() + ")";
    }

    @Generated
    public AmbulatoryPaymentClassificationRateData() {
    }

    @Generated
    public static final class Fields {
        public static final String AMBULATORY_PAYMENT_CLASSIFICATION_CODE = "ambulatoryPaymentClassificationCode";
        public static final String EFFECTIVE_DATE = "effectiveDate";
        public static final String MINIMUM_COINSURANCE_RATE = "minimumCoinsuranceRate";
        public static final String NATIONAL_COINSURANCE_RATE = "nationalCoinsuranceRate";
        public static final String PAYMENT_RATE = "paymentRate";
        public static final String STATUS_INDICATOR = "statusIndicator";
    }
}

