/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import lombok.Generated;

@Schema(description="Defines the response classification information for pricing.")
public class ReturnCodeData {
    @JsonIgnore
    public static final ReturnCodeData EMPTY_RETURN_CODE = new ReturnCodeData();
    @NotNull
    @Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters")
    @Schema(description="The reference code that reflects to the claim pricing result classification (error, outlier, etc.).", example="12")
    private @NotNull @Pattern(regexp="[A-Z\\d]{2}", message="must be two alphanumeric characters") String code;
    @NotNull
    @Size(min=5, max=256)
    @Schema(description="Descriptive text associated with the reference code.", example="INVALID_INPUT_20")
    private @NotNull @Size(min=5, max=256) String description;
    @Size(min=5, max=256)
    @Schema(description="Detailed text that provides additional context as to why a specific return code was generated by claim pricing.", example="Invalid rate component / PDPM units is zero / Invalid HIPPS code.")
    private @Size(min=5, max=256) String explanation;

    @Generated
    public ReturnCodeData(String code, String description, String explanation) {
        this.code = code;
        this.description = description;
        this.explanation = explanation;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getExplanation() {
        return this.explanation;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnCodeData)) {
            return false;
        }
        ReturnCodeData other = (ReturnCodeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$explanation = this.getExplanation();
        String other$explanation = other.getExplanation();
        return !(this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnCodeData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $explanation = this.getExplanation();
        result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReturnCodeData(code=" + this.getCode() + ", description=" + this.getDescription() + ", explanation=" + this.getExplanation() + ")";
    }

    @Generated
    public ReturnCodeData() {
    }
}

