/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.rules.CalculateCapitalDshAdjustment;
import gov.cms.fiss.pricers.ltch.core.rules.CalculateCapitalRate;
import gov.cms.fiss.pricers.ltch.core.rules.CalculateHoldValues;
import gov.cms.fiss.pricers.ltch.core.rules.CalculateIppsComparablePayment;
import gov.cms.fiss.pricers.ltch.core.rules.CalculateOperatingDshAmount;
import gov.cms.fiss.pricers.ltch.core.rules.CalculatePerDiem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CalcFinalPayment
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        PaymentType paymentType = calculationContext.getPaymentType();
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (!ErrorCode.isErrorCode(calculationContext.getReturnCode())) {
            switch (paymentType) {
                case STANDARD_OLD: {
                    paymentData.setTotalPayment(paymentData.getAdjustedPayment().add(paymentData.getOutlierPayment()).setScale(2, RoundingMode.HALF_UP));
                    break;
                }
                case SITE_NEUTRAL: {
                    paymentData.setSiteNeutralCostPayment(paymentData.getSiteNeutralCostPayment().multiply(calculationContext.getHoldBudgetNeutralFactor()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setSiteNeutralIppsPayment(paymentData.getSiteNeutralIppsPayment().multiply(calculationContext.getHoldBudgetNeutralFactor()).multiply(calculationContext.getHoldSiteNeutralIppsAdj()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setOutlierPayment(paymentData.getOutlierPayment().multiply(calculationContext.getHoldSiteNeutralIppsAdj()).setScale(2, RoundingMode.HALF_UP));
                    break;
                }
                case BLEND: {
                    paymentData.setSiteNeutralCostPayment(paymentData.getSiteNeutralCostPayment().multiply(calculationContext.getHoldBudgetNeutralFactor()).multiply(calculationContext.getHoldBlendSiteNeutral()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setSiteNeutralIppsPayment(paymentData.getSiteNeutralIppsPayment().multiply(calculationContext.getHoldBudgetNeutralFactor()).multiply(calculationContext.getHoldSiteNeutralIppsAdj()).multiply(calculationContext.getHoldBlendSiteNeutral()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setStandardFullPayment(paymentData.getStandardFullPayment().multiply(calculationContext.getHoldBlendStandard()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setStandardShortStayOutlierPayment(paymentData.getStandardShortStayOutlierPayment().multiply(calculationContext.getHoldBlendStandard()).setScale(2, RoundingMode.HALF_UP));
                    break;
                }
            }
            if (!paymentType.equals((Object)PaymentType.STANDARD_OLD)) {
                paymentData.setTotalPayment(paymentData.getStandardFullPayment().add(paymentData.getStandardShortStayOutlierPayment()).add(paymentData.getSiteNeutralCostPayment()).add(paymentData.getSiteNeutralIppsPayment()).add(paymentData.getOutlierPayment()).setScale(2, RoundingMode.HALF_UP));
                if ("Y".equals(providerData.getLtchDppIndicator())) {
                    this.calculateIPPSLikeAmt(calculationContext);
                    paymentData.setDischargePaymentPercentAmount(calculationContext.getHoldIPPSLikeAmt().subtract(paymentData.getTotalPayment()).setScale(2, RoundingMode.HALF_UP));
                    paymentData.setTotalPayment(paymentData.getTotalPayment().add(paymentData.getDischargePaymentPercentAmount()));
                }
            }
        }
    }

    void calculateIPPSLikeAmt(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        new CalculateIppsComparablePayment(List.of(new CalculateHoldValues(), new CalculateOperatingDshAmount(), new CalculateCapitalDshAdjustment(), new CalculateCapitalRate(), new CalculatePerDiem())).calculate(calculationContext);
        paymentData.setOutlierThresholdAmount(calculationContext.getHoldIppsPayAmount().add(calculationContext.getFixedLossAmountSiteNeutral()));
        if (BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), paymentData.getOutlierThresholdAmount())) {
            calculationContext.setHoldIPPSOutlier(paymentData.getFacilityCosts().subtract(paymentData.getOutlierThresholdAmount()).multiply(new BigDecimal("0.8")));
        }
        calculationContext.setHoldIPPSLikeAmt(calculationContext.getHoldIppsPayAmount().add(calculationContext.getHoldIPPSOutlier()));
    }
}

