/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateChargeThreshold
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateChargeThreshold.class);

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        PaymentType paymentType = calculationContext.getPaymentType();
        LtchClaimData claimData = calculationContext.getClaimData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal coveredDays = new BigDecimal(claimData.getCoveredDays());
        if (this.isOutlierAndSuccessful(calculationContext) && this.isNonBlendNonSiteNeutralOutlierPaymentOrChangeOfTherapy(calculationContext, paymentData, paymentType) && (BigDecimalUtils.isLessThan(coveredDays, calculationContext.getHoldLengthOfStay()) || "Y".equals(paymentData.getChangeOfTherapyIndicator()) && !BigDecimalUtils.isZero(providerData.getOperatingCostToChargeRatio()))) {
            paymentData.setChargeThresholdAmount(paymentData.getOutlierThresholdAmount().divide(providerData.getOperatingCostToChargeRatio(), RoundingMode.HALF_UP));
            if (Boolean.TRUE.equals(calculationContext.getPcPricer())) {
                calculationContext.applyReturnCode(ReturnCode.COST_OUTLIER_WITH_LOS_LT_COV_DAYS_67);
            }
        }
        calculationContext.setCalculateOutliers(true);
    }

    private boolean isNonBlendNonSiteNeutralOutlierPaymentOrChangeOfTherapy(LtchPricerContext calculationContext, LtchPaymentData paymentData, PaymentType paymentType) {
        return BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && (!paymentType.equals((Object)PaymentType.BLEND) || !BigDecimalUtils.isZero(calculationContext.getHoldOutlierPayAmountSiteNeutral())) || "Y".equals(paymentData.getChangeOfTherapyIndicator());
    }

    private boolean isOutlierAndSuccessful(LtchPricerContext calculationContext) {
        return calculationContext.getCalculateOutliers() != false && !ErrorCode.isErrorCode(calculationContext.getReturnCode());
    }
}

