/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules.rules2020;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ltch.core.tables.DataTables;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class DetermineIppsWageIndex
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Override
    public void calculate(LtchPricerContext calculationContext) {
        String trimmedGeolocation;
        InpatientProviderData providerData = calculationContext.getProviderData();
        LtchClaimData claimData = calculationContext.getClaimData();
        DataTables dataTables = calculationContext.getDataTables();
        CbsaWageIndexEntry entry = dataTables.getIppsCbsaWageIndex(trimmedGeolocation = "00".equalsIgnoreCase(trimmedGeolocation = StringUtils.trimToEmpty(providerData.getCbsaActualGeographicLocation())) ? "03" : trimmedGeolocation, providerData.getEffectiveDate());
        if (entry != null && !claimData.getDischargeDate().isBefore(entry.getEffectiveDate()) && ("98".equalsIgnoreCase(trimmedGeolocation) || "99".equalsIgnoreCase(trimmedGeolocation) || LocalDateUtils.inRange(entry.getEffectiveDate(), calculationContext.getFyBegin(), calculationContext.getFyEnd()))) {
            calculationContext.setHoldProvIppsCBSA(entry);
        } else if (entry == null) {
            calculationContext.applyReturnCode(ReturnCode.CBSA_WAGE_INDEX_NOT_FOUND_60);
        }
        String defaultedGeolocation = this.getGeolocation(calculationContext.getProviderData().getStateCode());
        this.assignFloorCBSA(calculationContext, calculationContext.getReturnCode(), defaultedGeolocation);
        entry = this.getIppsCbsaTableEntry(calculationContext, entry);
        entry = this.setIppsCbsaTableEntrySize(claimData, trimmedGeolocation, entry);
        this.setIppsCbsaTableEntrySize(claimData, trimmedGeolocation, entry);
        calculationContext.setHoldProvIppsCBSA(entry);
        calculationContext.calculateIppsLaborShares();
    }

    protected String getGeolocation(String geolocation) {
        return "00".equals(geolocation) ? "03" : geolocation;
    }

    private CbsaWageIndexEntry setIppsCbsaTableEntrySize(LtchClaimData claimData, String trimmedGeolocation, CbsaWageIndexEntry entry) {
        if (entry != null && !claimData.getDischargeDate().isBefore(entry.getEffectiveDate())) {
            String size = "O";
            if (trimmedGeolocation.length() <= 2) {
                size = "R";
            } else if ("L".equals(entry.getSize())) {
                size = "L";
            }
            return entry.copyBuilder().size(size).build();
        }
        return entry;
    }

    protected CbsaWageIndexEntry getIppsCbsaTableEntry(LtchPricerContext calculationContext, CbsaWageIndexEntry entry) {
        if (entry != null && BigDecimalUtils.isGreaterThan(calculationContext.getWageIndexFloor().getWageIndex(), entry.getGeographicWageIndex())) {
            entry = CbsaWageIndexEntry.builder().cbsa(calculationContext.getWageIndexFloor().getCbsaPadded()).effectiveDate(calculationContext.getWageIndexFloor().getEffectiveDate()).geographicWageIndex(calculationContext.getWageIndexFloor().getWageIndex()).build();
        }
        return entry;
    }

    protected void assignFloorCBSA(LtchPricerContext calculationContext, String returnCode, String geolocation) {
        WageIppsIndexRuralEntry ruralEntry = WageIppsIndexRuralEntry.DEFAULT.build();
        LocalDate dischargeDate = calculationContext.getClaimData().getDischargeDate();
        if (StringUtils.equals(ReturnCode.NORMAL_DRG_00.getCode(), returnCode)) {
            ruralEntry = this.getRuralFloorIpps(calculationContext, geolocation, dischargeDate);
        }
        calculationContext.setWageIndexFloor(ruralEntry);
    }

    protected WageIppsIndexRuralEntry getRuralFloorIpps(LtchPricerContext context, String geolocation, LocalDate dischargeDate) {
        return Optional.ofNullable(context.getDataTables().getWageIppsIndexRural(geolocation, dischargeDate)).orElse(WageIppsIndexRuralEntry.DEFAULT.build());
    }
}

