/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.tables;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CbsaWageIndexLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/cbsa-wage-index-%s.csv";
    private final CsvContentReader<CbsaWageIndexEntry> contentProvider = new CsvContentReader<CbsaWageIndexEntry>(CbsaWageIndexEntry.class).customizeSchema(schema -> schema.withHeader().withColumnReordering(true));

    public CbsaWageIndexLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
        this.contentProvider.customizeMapper(mapper -> (CsvMapper)mapper.disable(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS).disable(CsvParser.Feature.FAIL_ON_MISSING_HEADER_COLUMNS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES));
    }

    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> generate(String csvFile) {
        List<CbsaWageIndexEntry> content = this.contentProvider.read(csvFile);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<CbsaWageIndexEntry, ?, NavigableMap> collector = Collectors.toMap(CbsaWageIndexEntry::getEffectiveDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(CbsaWageIndexEntry::getCbsa, content, HashMap::new, collector);
    }
}

