/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.resources;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.application.resources.BaseCsvResource;
import gov.cms.fiss.pricers.ltch.LtchPricerConfiguration;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgRetrievalResponse;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.core.tables.DataTables;
import io.dropwizard.jersey.jsr310.LocalDateParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.stream.Collectors;

@Path(value="/v1/ip-drg-entries")
public class InpatientDrgEntryResource
extends BaseCsvResource<InpatientDrgsTableEntry> {
    public InpatientDrgEntryResource(LtchPricerConfiguration pricerConfiguration) {
        super(pricerConfiguration, csvMapper -> csvMapper.schemaFor(InpatientDrgsTableEntry.class).withHeader());
    }

    @Override
    protected void extractAndPopulate(CsvMapper csvMapper, CsvSchema csvSchema, Integer pricerYear) {
        Optional<Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>>> matchingData = Optional.ofNullable(DataTables.forYear(pricerYear).getIppsDrgsMap());
        if (matchingData.isPresent()) {
            List entries = matchingData.map(Map::entrySet).stream().flatMap(s2 -> s2.stream().map(Map.Entry::getValue)).map(Map::entrySet).flatMap(Collection::stream).map(Map.Entry::getValue).sorted(Comparator.comparing(InpatientDrgsTableEntry::getDiagnosticRelatedGroup).thenComparing(InpatientDrgsTableEntry::getEffectiveDate)).collect(Collectors.toList());
            this.addEntries(pricerYear, entries);
            try {
                this.addCsv(pricerYear, csvMapper.writer(csvSchema).writeValueAsString(entries));
            }
            catch (JsonProcessingException jpe) {
                throw new IllegalStateException("Failed to convert entries to CSV for year " + pricerYear, jpe);
            }
        }
    }

    @GET
    @Operation(summary="Retrieves all inpatient diagnostic-related group (DRG) data for a given fiscal year.", description="Retrieves all inpatient DRG data for all effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching inpatient DRG data", content={@Content(mediaType="application/json", schema=@Schema(implementation=InpatientDrgRetrievalResponse.class)), @Content(mediaType="text/csv")}), @ApiResponse(responseCode="400", description="Invalid request"), @ApiResponse(responseCode="404", description="Year not found"), @ApiResponse(responseCode="406", description="Unsupported media type requested"), @ApiResponse(responseCode="500", description="Data retrieval error")})
    @Path(value="{year}")
    @Produces(value={"application/json", "text/csv"})
    @Timed
    public Response findAll(@Max(value=9999L) @Min(value=2000L) @NotNull @PathParam(value="year") @Parameter(description="The fiscal year for which data will be retrieved.") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @HeaderParam(value="Accept") String contentType) {
        return this.getPerYearEntries(year, contentType, InpatientDrgRetrievalResponse::new);
    }

    @GET
    @Operation(summary="Retrieve all matching inpatient DRG data for a given year.", description="Returns the data for a specific inpatient DRG for matching effective dates within the provided fiscal year.", responses={@ApiResponse(responseCode="200", description="The matching DRG data", content={@Content(mediaType="application/json", schema=@Schema(implementation=InpatientDrgRetrievalResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request"), @ApiResponse(responseCode="404", description="Year or specified DRG not found"), @ApiResponse(responseCode="500", description="Data retrieval error")})
    @Path(value="{year}/{drg}")
    @Produces(value={"application/json"})
    @Timed
    public Response findMatching(@Max(value=9999L) @Min(value=2000L) @NotNull @Parameter(description="The fiscal year for which data will be retrieved.", required=true) @PathParam(value="year") @Max(value=9999L) @Min(value=2000L) @NotNull int year, @NotNull @Parameter(description="The inpatient diagnostic-related group for which data will be retrieved.", required=true) @PathParam(value="drg") @Pattern(regexp="^\\d{3}$") @NotNull @Pattern(regexp="^\\d{3}$") String diagnosticRelatedGroup, @Parameter(description="Filters data so that only the inpatient DRG data effective as of the provided date will be returned; if omitted, all values for the year will be returned.", example="2020-04-01", schema=@Schema(implementation=LocalDate.class)) @QueryParam(value="effectiveDate") LocalDateParam effectiveDate) {
        return this.findMatchingEntries(() -> {
            if (null != effectiveDate) {
                Optional<InpatientDrgsTableEntry> matchedEntry = Optional.ofNullable(DataTables.forYear(year)).map(dt -> dt.getInpatientDrgEntry(diagnosticRelatedGroup, (LocalDate)effectiveDate.get()));
                return matchedEntry.map(Collections::singletonList).orElseGet(ArrayList::new);
            }
            Optional<Collection> matchingData = Optional.ofNullable(DataTables.forYear(year)).map(DataTables::getIppsDrgsMap).map(ct -> (NavigableMap)ct.get(diagnosticRelatedGroup)).map(Map::values);
            return matchingData.map(ArrayList::new).orElseGet(ArrayList::new);
        }, InpatientDrgRetrievalResponse::new);
    }
}

