// Generated by delombok at Thu Sep 11 13:52:26 UTC 2025
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateHighCostOutlierBlend implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateHighCostOutlierBlend.class);
  private static final String ONE = "1";

  /**
   * <pre>
   * *-------------------------------------------------------------*
   * * FOR BLENDED PAYMENT CLAIMS                                  *
   * * (RECEIVE 50% STANDARD PAYMENT + 50% SITE-NEUTRAL PAYMENT)   *
   * *-------------------------------------------------------------*
   * * - DETERMINE WHICH PAYMENT TO USE TO CALC OUTLIER THRESHOLDS *
   * *   BASED ON CLAIMS'S PAYMENT TYPE &amp; PAYMENT FIELD VALUES *
   * * - CALCULATE STANDARD PAYMENT OUTLIER THRESHOLD              *
   * * - CALCULATE SITE-NEUTRAL PAYMENT OUTLIER THRESHOLD          *
   * * - CALCULATE HIGH-COST OUTLIER IF APPLICABLE (50/50 BLEND)   *
   * *-------------------------------------------------------------*
   * </pre>
   */
  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final PaymentType paymentType = calculationContext.getPaymentType();
    final SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
    final SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    final LtchClaimData claimData = calculationContext.getClaimData();
    if (isOutlierAndSuccessful(calculationContext)) {
      if (paymentType.equals(PaymentType.BLEND)) {
        calculateStandardOutlierThreshold(calculationContext, secondaryPaymentTypeStandard, paymentData);
        // *-------------------------------------------------------------*
        // * CALCULATE SITE-NEUTRAL OUTLIER THRESHOLD                    *
        // *-------------------------------------------------------------*
        if (secondaryPaymentTypeSiteNeutral.equals(SecondaryPaymentTypeSiteNeutral.IPPS)) {
          // COMPUTE PPS-OUTLIER-THRESHOLD ROUNDED =
          //                   PPS-SITE-NEUTRAL-IPPS-PMT +
          //                   H-FIXED-LOSS-AMT-SNT
          paymentData.setOutlierThresholdAmount(paymentData.getSiteNeutralIppsPayment().add(calculationContext.getFixedLossAmountSiteNeutral()));
        }
        // *-------------------------------------------------------------*
        // * CALCULATE STANDARD PAYMENT PORTION OF HIGH-COST OUTLIER IF  *
        // * COSTS EXCEED STANDARD PAYMENT THRESHOLD                     *
        // *-------------------------------------------------------------*
        // IF PPS-FAC-COSTS > H-OUTLIER-THRESHOLD-STD
        if (BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), calculationContext.getHoldOutlierThresholdStandard())) {
          // COMPUTE H-OUTLIER-PAY-AMT-STD ROUNDED =
          //                   (PPS-FAC-COSTS - H-OUTLIER-THRESHOLD-STD) * .8
          //                   * H-BLEND-STD
          calculationContext.setHoldOutlierPayAmountStandard(paymentData.getFacilityCosts().subtract(calculationContext.getHoldOutlierThresholdStandard()).multiply(new BigDecimal("0.8")).multiply(calculationContext.getHoldBlendStandard()).setScale(2, RoundingMode.HALF_UP));
        }
        // *-------------------------------------------------------------*
        // * CALCULATE SITE-NEUTRAL PORTION OF HIGH-COST OUTLIER IF      *
        // * COSTS EXCEED THE SITE-NEUTRAL PAYMENT THRESHOLD             *
        // *-------------------------------------------------------------*
        // IF PMT-SITE-NEUT-IPPS AND
        //       PPS-FAC-COSTS > PPS-OUTLIER-THRESHOLD
        if (secondaryPaymentTypeSiteNeutral.equals(SecondaryPaymentTypeSiteNeutral.IPPS) && BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), paymentData.getOutlierThresholdAmount())) {
          // COMPUTE H-OUTLIER-PAY-AMT-SNT ROUNDED =
          //                  (((PPS-FAC-COSTS - PPS-OUTLIER-THRESHOLD) * .8)
          //                   * H-BLEND-SNT)
          calculationContext.setHoldOutlierPayAmountSiteNeutral(paymentData.getFacilityCosts().subtract(paymentData.getOutlierThresholdAmount()).multiply(new BigDecimal("0.8")).multiply(calculationContext.getHoldBlendSiteNeutral()).setScale(2, RoundingMode.HALF_UP));
        }
        // *-------------------------------------------------------------*
        // * CALCULATE TOTAL BLENDED HIGH-COST OUTLIER:                  *
        // * ADD THE SITE-NEUTRAL PAYMENT PORTION OF HIGH-COST OUTLIER   *
        // * TO THE STANDARD PAYMENT PORTION                             *
        // *-------------------------------------------------------------*
        // COMPUTE PPS-OUTLIER-PAY-AMT ROUNDED =
        //                H-OUTLIER-PAY-AMT-STD +
        //                (H-OUTLIER-PAY-AMT-SNT * H-SITE-NEUTRAL-IPPS-ADJ)
        paymentData.setOutlierPayment(calculationContext.getHoldOutlierPayAmountSiteNeutral().multiply(calculationContext.getHoldSiteNeutralIppsAdj()).add(calculationContext.getHoldOutlierPayAmountStandard()).setScale(2, RoundingMode.HALF_UP));
      }
      // *-------------------------------------------------------------*
      // * FOR ALL CLAIMS:                                             *
      // *-------------------------------------------------------------*
      // * SET HIGH-COST OUTLIER TO $0 IF BILL SPECIAL PAY IND. = '1'  *
      // *-------------------------------------------------------------*
      // TODO: Comment 1.5yr out-of-date. move this into the non blended rule
      if (ONE.equals(claimData.getOutlierSpecialPaymentIndicator())) {
        paymentData.setOutlierPayment(BigDecimal.ZERO);
      }
    }
  }

  private void calculateStandardOutlierThreshold(LtchPricerContext calculationContext, SecondaryPaymentTypeStandard secondaryPaymentTypeStandard, LtchPaymentData paymentData) {
    // *-------------------------------------------------------------*
    // * CALCULATE STANDARD OUTLIER THRESHOLD                        *
    // *-------------------------------------------------------------*
    if (secondaryPaymentTypeStandard.equals(SecondaryPaymentTypeStandard.FULL)) {
      // COMPUTE H-OUTLIER-THRESHOLD-STD ROUNDED =
      //                   PPS-STANDARD-FULL-PMT + H-FIXED-LOSS-AMT-STD
      calculationContext.setHoldOutlierThresholdStandard(paymentData.getStandardFullPayment().add(calculationContext.getFixedLossAmountStandard()));
    } else {
      // COMPUTE H-OUTLIER-THRESHOLD-STD ROUNDED =
      //                   PPS-STANDARD-SSO-PMT + H-FIXED-LOSS-AMT-STD
      calculationContext.setHoldOutlierThresholdStandard(paymentData.getStandardShortStayOutlierPayment().add(calculationContext.getFixedLossAmountStandard()));
    }
  }

  private boolean isOutlierAndSuccessful(LtchPricerContext calculationContext) {
    return calculationContext.getCalculateOutliers() && !ErrorCode.isErrorCode(calculationContext.getReturnCode());
  }
}
