// Generated by delombok at Thu Sep 11 13:52:26 UTC 2025
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Calculates a short-stay blended payment if appropriate.
 *
 * <pre>
 * ***************************************************************
 * *    IF THE LENGTH OF STAY IS LESS THAN OR EQUAL TO 5/6       *
 * *      OF THE AVG. LENGTH OF STAY THEN:                       *
 * *      - PAY THE SHORT-STAY BLENDED PAYMENT                   *
 * *      - SET RETURN CODE FOR OLD POLICY CLAIMS ONLY TO        *
 * *        INDICATE SHORT STAY PAYMENT                          *
 * ***************************************************************
 * </pre>
 *
 * <p>Converted from {@code 3200-CALC-STANDARD-PMT} and {@code 3400-SHORT-STAY} in the COBOL code.
 */
public class CalculateShortStay implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateShortStay.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    // IF H-LOS <= H-SSOT
    // IF PMT-STANDARD-NEW OR PMT-BLEND
    return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
  }

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    // COMPUTE H-SS-PAY-AMT ROUNDED =
    //         ((PPS-DRG-ADJ-PAY-AMT / PPS-AVG-LOS) * H-LOS) * 1.2
    calculationContext.setHoldShortStayPayAmount(paymentData.getAdjustedPayment().divide(paymentData.getAverageLengthOfStay(), 3, RoundingMode.DOWN).multiply(calculationContext.getHoldLengthOfStay()).multiply(new BigDecimal("1.2")).setScale(2, RoundingMode.HALF_UP));
  }
}
