/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.api.v1;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import lombok.Generated;

@JsonPropertyOrder(value={"diagnosticRelatedGroup", "relativeWeight", "arithmeticMeanLengthOfStay"})
@Schema(description="The long-term care diagnostic-related group (DRG) information.")
public class LtchDrgsTableEntry {
    @DecimalMax(value="99.9")
    @DecimalMin(value="0")
    @Digits(integer=2, fraction=1)
    @NotNull
    @Schema(description="Arithmetic mean length of stay.", example="1.2", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="WWM-ALOS", value="PIC 9(02)V9(01)")})})
    private @DecimalMax(value="99.9") @DecimalMin(value="0") @Digits(integer=2, fraction=1) @NotNull BigDecimal arithmeticMeanLengthOfStay;
    @NotNull
    @Pattern(regexp="\\d{3}")
    @Schema(description="Diagnostic-related group.", example="077", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="WWM-DRG", value="PIC X(3)")})})
    private @NotNull @Pattern(regexp="\\d{3}") String diagnosticRelatedGroup;
    @DecimalMax(value="9.9999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=4)
    @Schema(description="Relative group weight.", example="3.3326", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="WWM-RELWT", value="PIC 9(01)V9(04)")})})
    private @DecimalMax(value="9.9999") @DecimalMin(value="0") @Digits(integer=1, fraction=4) BigDecimal relativeWeight;

    @Generated
    public LtchDrgsTableEntry() {
    }

    @Generated
    public BigDecimal getArithmeticMeanLengthOfStay() {
        return this.arithmeticMeanLengthOfStay;
    }

    @Generated
    public String getDiagnosticRelatedGroup() {
        return this.diagnosticRelatedGroup;
    }

    @Generated
    public BigDecimal getRelativeWeight() {
        return this.relativeWeight;
    }

    @Generated
    public void setArithmeticMeanLengthOfStay(BigDecimal arithmeticMeanLengthOfStay) {
        this.arithmeticMeanLengthOfStay = arithmeticMeanLengthOfStay;
    }

    @Generated
    public void setDiagnosticRelatedGroup(String diagnosticRelatedGroup) {
        this.diagnosticRelatedGroup = diagnosticRelatedGroup;
    }

    @Generated
    public void setRelativeWeight(BigDecimal relativeWeight) {
        this.relativeWeight = relativeWeight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LtchDrgsTableEntry)) {
            return false;
        }
        LtchDrgsTableEntry other = (LtchDrgsTableEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
        BigDecimal other$arithmeticMeanLengthOfStay = other.getArithmeticMeanLengthOfStay();
        if (this$arithmeticMeanLengthOfStay == null ? other$arithmeticMeanLengthOfStay != null : !((Object)this$arithmeticMeanLengthOfStay).equals(other$arithmeticMeanLengthOfStay)) {
            return false;
        }
        String this$diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
        String other$diagnosticRelatedGroup = other.getDiagnosticRelatedGroup();
        if (this$diagnosticRelatedGroup == null ? other$diagnosticRelatedGroup != null : !this$diagnosticRelatedGroup.equals(other$diagnosticRelatedGroup)) {
            return false;
        }
        BigDecimal this$relativeWeight = this.getRelativeWeight();
        BigDecimal other$relativeWeight = other.getRelativeWeight();
        return !(this$relativeWeight == null ? other$relativeWeight != null : !((Object)this$relativeWeight).equals(other$relativeWeight));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LtchDrgsTableEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $arithmeticMeanLengthOfStay = this.getArithmeticMeanLengthOfStay();
        result = result * 59 + ($arithmeticMeanLengthOfStay == null ? 43 : ((Object)$arithmeticMeanLengthOfStay).hashCode());
        String $diagnosticRelatedGroup = this.getDiagnosticRelatedGroup();
        result = result * 59 + ($diagnosticRelatedGroup == null ? 43 : $diagnosticRelatedGroup.hashCode());
        BigDecimal $relativeWeight = this.getRelativeWeight();
        result = result * 59 + ($relativeWeight == null ? 43 : ((Object)$relativeWeight).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LtchDrgsTableEntry(arithmeticMeanLengthOfStay=" + this.getArithmeticMeanLengthOfStay() + ", diagnosticRelatedGroup=" + this.getDiagnosticRelatedGroup() + ", relativeWeight=" + this.getRelativeWeight() + ")";
    }

    @Generated
    public static final class Fields {
        public static final String ARITHMETIC_MEAN_LENGTH_OF_STAY = "arithmeticMeanLengthOfStay";
        public static final String DIAGNOSTIC_RELATED_GROUP = "diagnosticRelatedGroup";
        public static final String RELATIVE_WEIGHT = "relativeWeight";
    }
}

