/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalculateHighCostOutlier
implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculateHighCostOutlier.class);

    @Override
    public void calculate(LtchPricerContext calculationContext) {
        LtchPaymentData paymentData = calculationContext.getPaymentData();
        PaymentType paymentType = calculationContext.getPaymentType();
        SecondaryPaymentTypeStandard secondaryPaymentTypeStandard = calculationContext.getSecondaryPaymentTypeStandard();
        SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral = calculationContext.getSecondaryPaymentTypeSiteNeutral();
        if (this.isOutlierAndIsNotErrorCode(calculationContext)) {
            if (paymentType.equals((Object)PaymentType.STANDARD_OLD)) {
                paymentData.setOutlierThresholdAmount(paymentData.getAdjustedPayment().add(calculationContext.getFixedLossAmountStandard()));
            }
            if (paymentType.equals((Object)PaymentType.STANDARD_NEW)) {
                if (secondaryPaymentTypeStandard.equals((Object)SecondaryPaymentTypeStandard.FULL)) {
                    paymentData.setOutlierThresholdAmount(paymentData.getStandardFullPayment().add(calculationContext.getFixedLossAmountStandard()));
                } else {
                    paymentData.setOutlierThresholdAmount(paymentData.getStandardShortStayOutlierPayment().add(calculationContext.getFixedLossAmountStandard()));
                }
            }
            if (paymentType.equals((Object)PaymentType.SITE_NEUTRAL) && secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.IPPS)) {
                paymentData.setOutlierThresholdAmount(paymentData.getSiteNeutralIppsPayment().add(calculationContext.getFixedLossAmountSiteNeutral()));
            }
            if (this.isNonBlendNonSiteNeutralCostPayment(paymentData, paymentType, secondaryPaymentTypeSiteNeutral)) {
                paymentData.setOutlierPayment(new BigDecimal("0.8").multiply(paymentData.getFacilityCosts().subtract(paymentData.getOutlierThresholdAmount())).setScale(2, RoundingMode.HALF_UP));
            }
        }
    }

    private boolean isNonBlendNonSiteNeutralCostPayment(LtchPaymentData paymentData, PaymentType paymentType, SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral) {
        return !paymentType.equals((Object)PaymentType.BLEND) && (!paymentType.equals((Object)PaymentType.SITE_NEUTRAL) || !secondaryPaymentTypeSiteNeutral.equals((Object)SecondaryPaymentTypeSiteNeutral.COST)) && BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), paymentData.getOutlierThresholdAmount());
    }

    private boolean isOutlierAndIsNotErrorCode(LtchPricerContext calculationContext) {
        return calculationContext.getCalculateOutliers() != false && ErrorCode.isNotNewCodeAndNotOldCode(calculationContext.getReturnCode());
    }
}

